﻿import viz,vizfx

viz.go()
model=vizfx.addChild('./Earth/main.osgb')
viz.MainView.setPosition(2270347.75*2, 3137376.25*2, 7425973.0*2)
viz.MainView.lookAt([0,0,0])

composer=vizfx.getComposer()
model.generateEffects(composer=composer)

code="""
Effect {
    Float rmin{value 0}
    Float rmax{value 255}
    Float gmin{value 0}
    Float gmax{value 255}
    Float bmin{value 0}
    Float bmax{value 255}
    Shader{
        BEGIN FinalColor
        float r=(vizfx_VertexColor.r-rmin)*255/(rmax-rmin);
        float g=(vizfx_VertexColor.g-gmin)*255/(gmax-gmin);
        float b=(vizfx_VertexColor.b-bmin)*255/(bmax-bmin);
        gl_FragColor.rgb=vec3(r,g,b);
        END
    }
}
"""

effect=viz.addEffect(code)
model.apply(effect)
model.setUniformFloat('bmin',50)