﻿"""
This is a very simple demo, but it also illustrates the use of viewpoints with
vizconnect.  

Viewpoints are a method for forcing a display to be at a particular location.
The sample viewpoint in this script places the user at the top of a balcony.

You can test the effect of setting the viewpoint by adjusting the position values
for the viewpoint at the bottom of the script
"""

import viz
import vizact
import vizconnect
import view_collision


# start the vizconnect session stored in the given directory
viz.go(viz.FULLSCREEN)
vizconnect.go("vizconnect_Config.py")

# oriMode sets what the viewpoint is resetting to. For example...
# vizconnect.VIEWPOINT_MATCH_DISPLAY
# matches orientation of the display to the orientation of the viewpoint
# 
# vizconnect.VIEWPOINT_MATCH_FEET
# matches orientation of the feet to the orientation of the viewpoint
# 
# vizconnect.VIEWPOINT_MATCH_BASE
# matches orientation of the base object (transport, avatar, tracker) to the orientation of the viewpoint
#
# Similar for posMode
oriMode = vizconnect.VIEWPOINT_MATCH_DISPLAY
posMode = vizconnect.VIEWPOINT_MATCH_FEET

# Add a viewpoint.
vp = vizconnect.addViewpoint(	pos=[-10.449878692626953, 1.1761860847473145, 9.395699501037598],
								euler=[135.88055419921875, 0.9000043272972107, -0.0],
								posMode=posMode,
								oriMode=oriMode,
								constant=False,
								)

# Displays are added to viewpoints, the viewpoint will traverse the scenegraph to
# determine if the display is attached to an avatar, tracker, etc in order to
# perform the requested resets.
vp.add(vizconnect.getDisplay())

# Call reset viewpoints, which forces the display into the viewpoint position.
# This function can be called as often as desired, it is currently also mapped
# onto the insert button.
vizconnect.resetViewpoints()
# add a reset key so when r is pressed the user is moved back back to the viewpoint
vizact.onkeydown('r', vizconnect.resetViewpoints)



#Getting the viewpoint data from 
view = viz.MainView
def getCurrentViewPointData():
	print 'the position ',view.getPosition()
	print 'the euler',view.getEuler()
vizact.ontimer(1,getCurrentViewPointData)






avatar = vizconnect.getAvatar().getRaw()
avatar.state(1)

'''
#linkk = viz.link(viz.MainView,avatar)

linkk = viz.link(avatar,viz.MainView)
linkk.preTrans([0,0.9,2])

import vizcam
viz.cam.setHandler(vizcam.FlyNavigate())
'''



viz.add('./models/untitledWithFloor.osgb')


viz.add('./models/sky_day.osgb')

def onKeyDOWN(key): 
    global avatar
    if key == 'w' or key == 's' or key == 'a' or key == 'd' or key == 'q' or key == 'e': 
        print 'w  and s key pressed' 
        avatar.state(2)
    elif key == "r": 
        print 'R key pressed' 

viz.callback(viz.KEYDOWN_EVENT,onKeyDOWN) 



def onKeyUp(key): 
    global avatar
    if key == 'w' or key == 's' or key == 'a' or key == 'd' or key == 'q' or key == 'e': 
        print 'w  and s key released' 
        avatar.state(1) #looping idle animation
    elif key == "r": 
        print 'R key released' 

viz.callback(viz.KEYUP_EVENT,onKeyUp) 


           
         
