﻿"""
Press spacebar to save highlighted pattern to file
Press F12 to display camera debugging controls
"""
import viz
import vizact
import vizinput
viz.go()

#Add ARToolkit extension
ar = viz.add('artoolkit.dle')

#Create camera from texture
#camera = ar.addWebCamera()
camera = ar.addWebCamera()
camera.largestMarker = None




#Example for creating a set of lines: 
viz.startLayer(viz.LINES) 
viz.vertexColor(0,0,1)
viz.lineWidth(5)
viz.vertexColor(0,1,0) 
viz.vertex(-1,1,5) #Vertices are split into pairs. 
viz.vertex(-1,18,5) 

viz.vertex(-1,1,5) 
viz.vertex(10,2,-6)

viz.vertex(10,2,-6)
viz.vertex(10,18,-6)

viz.vertex(10,18,-6)
viz.vertex(-1,18,5) 

viz.vertex(10,2,-6)
viz.vertex(40,0,-50)

viz.vertex(40,2,-50)
viz.vertex(40,18,-50)

viz.vertex(40,18,-50)
viz.vertex(10,18,-6)
 
square = viz.endLayer() 






def UpdateLargestMarker():
	"""Finds raw marker with largest pixel area"""
	raw = camera.getRawMarkers()
	print'The markers are',raw
	if raw:
		raw.sort(key = lambda r: r.area)
		camera.largestMarker = raw[-1]
		square.setMatrix( camera.getRawMarkerMatrix(raw[-1],width=5000) )
		square.visible(1)
	else:
		camera.largestMarker = None
		square.visible(0)

#Update raw pattern every frame
vizact.onupdate(viz.PRIORITY_INPUT-1,UpdateLargestMarker)

def SavePattern():
	"""Displays save dialog for creating pattern from largest raw marker"""
	if camera.largestMarker is not None:
		filename = vizinput.fileSave()
		if filename:
			camera.savePattern(filename,camera.largestMarker)

#Save current pattern when spacebar is pressed
vizact.onkeyup(' ',SavePattern)

#Allow configuring camera
import vizconfig
vizconfig.register(camera)
vizconfig.getConfigWindow().setWindowAlignment(viz.ALIGN_RIGHT_BOTTOM)
