import viz

projModifier = 0


class VizProjector(viz.VizNode):
	
	def __init__(self,id):
		viz.VizNode.__init__(self,id)
		self.projID = -1
		
	def fov(self,vert,ratio):
		projModifier.command(self.projID,'',vert,ratio,0,1)
		
	def ortho(self,width,height):
		projModifier.command(self.projID,'',width,height,0,3)
		
	def border(self,r,g,b):
		projModifier.command(self.projID,'',r,g,b,2)
		
	def image(self,texture):
		texture.modify(projModifier,self.projID)
		
	def affect(self,node,textureNum=2):
		node.modify(projModifier,2,'',self.projID,textureNum,1)
		
	def unaffect(self,node,textureNum=2):
		node.modify(projModifier,2,'',self.projID,textureNum,0)

def add(texture, parent = viz.WORLD, scene = viz.MAIN_SCENE):
	
	global projModifier
	
	#Initialize the modifier
	if projModifier == 0:
		projModifier = viz.add('projector.dlm')
		
	#Create a group node that holds the projector
	group = viz.addgroup(parent,scene)
	
	#Modify the group node as a projector
	group.modify(projModifier,1)
	
	#Get the id of the new projector from the modifier
	projID = int(projModifier.get()[0])
	
	#Send the texture to the modifier
	texture.modify(projModifier,projID)
	
	#Create and return a VizProjector object
	retval = VizProjector(group.id)
	retval.projID = projID
	
	#Set default border color to white
	retval.border(1,1,1)
	
	return retval
	