import viz

#Record the script, should be called before viz.go()
import vizVCR
r = vizVCR.Recorder()
r.startRecording('recorded.txt')

viz.go()

import vizinfo

info = vizinfo.add( 'This tutorial demonstrates the use of the vizinfo modual.' )
info.translate( .98, .1 )

viz.clearcolor(0.5,0.5,1)

#Add object that vizinfo GUI objects will modify
wheelbarrow = viz.add('wheelbarrow.ive')
viz.add( 'ball.wrl' )
wheelbarrow.translate(0,1,3)
wheelbarrow.rotate(0,1,0, -90)	

#Initialize info box with some instructions
info = vizinfo.add( 'Use the slider to spin the wheelbarrow.\nThe radio button change the color.' )
info.title( 'Wheelbarrow Spinner' ) #Set title text
info.drag( viz.ON ) #Make the title bar draggable

#Add slider in info box
slider = info.add( viz.SLIDER, 'Spin Speed' )
slider.scale( 2, 2, 2 )
slider.label.color( viz.RED )

#Add radio buttons
red = info.add( viz.RADIO, 0, 'Red' )
white = info.add( viz.RADIO, 0, 'White' )
blue = info.add( viz.RADIO, 0, 'Blue' )

#Set callbacks for changing wheelbarrow color with radio buttons
vizact.onbuttondown( red, wheelbarrow.color, viz.RED )
vizact.onbuttondown( white, wheelbarrow.color, viz.WHITE )
vizact.onbuttondown( blue, wheelbarrow.color, viz.BLUE )


#Keyboard commands that modify the info box
def keyboardEvent( key ):
	if key == 'e':
		info.expand() #Maximize info box
	elif key == 's':
		info.shrink() #Minimize info box
	elif key == 'm':
		info.message( viz.input('Enter info text:') ) #Change directions message
	elif key == 't':
		info.title( viz.input('Enter title text:') ) #Change title message

viz.callback( viz.KEYBOARD_EVENT, keyboardEvent )


def sliderEvent( pos ):
	#Make wheelbarrow spin according to slider position
	wheelbarrow.runAction( vizact.spin(0, -1, 0, 500 * pos) )

vizact.onslider( slider, sliderEvent )