import viz

class Points(viz.VizNode):
	def __init__(self):
		
		self.__point = viz.add('lightpoint.dlc')
		
		self.__numPoints = 0
		
		viz.VizNode.__init__(self,self.__point.id)
		
		
	def addPoint(self,pos=None,color=None,size=None):
		"""Add a point"""
		self.__point.command(0)
		index = self.__numPoints
		self.__numPoints += 1
		
		if pos is not None:
			self.setPointPos(index,pos)
			
		if color is not None:
			self.setPointColor(index,color)
			
		if size is not None:
			self.setPointSize(index,size)

		return index
		
	def setPointPos(self,i,pos):
		"""Set the position of a point"""
		self.__point.command(1,'',i,pos[0],pos[1],pos[2])
		
	def setPointColor(self,i,color):
		"""Set the color of a point"""
		self.__point.command(2,'',i,color[0],color[1],color[2])
		
	def setPointSize(self,i,size):
		"""Set the size of a point"""
		self.__point.command(3,'',i,size)
		
	def setPointIntensity(self,i,intensity):
		"""Set intensity of point"""
		self.__point.command(4,'',i,intensity)

	def getNumPoints(self):
		"""Return the number of point"""
		self.__point.command(5)
		return int(self.__point.get()[0])

	def getPointPos(self,i):
		"""Return position of point"""
		self.__point.command(6,'',i)
		return self.__point.get()[:3]
		
	def getPointColor(self,i):
		"""Return color of point"""
		self.__point.command(7,'',i)
		return self.__point.get()[:3]
		
	def getPointSize(self,i):
		"""Return size of point"""
		self.__point.command(8,'',i)
		return self.__point.get()[0]
		
	def setPointVisible(self,i,visible):
		"""Set visibility of point"""
		self.__point.command(9,'',i,visible)
	
	def getPointVisible(self,i):
		"""Get visibility of point"""
		self.__point.command(10,'',i)
		return bool(self.__point.get()[0])
		