import viz
viz.go()

#Import point plugin
import vizpoint

#Create a point node
p = vizpoint.Points()

#Add a grid of points to the point node
for x in range(50):
	for z in range(50):
		p.addPoint(pos=(x*0.5,0,z*0.5),color=viz.RED,size=0.03)
		
#Move viewpoint back
viz.move(0,-1,-5)

#Create a timer to dynamically change points every frame
import math

def ontimer(num):
	if num == 0:
		#Change position of first column
		time = viz.get(viz.FRAME_TIMESTAMP)
		for i in range(50):
			pos = p.getPointPos(i)
			pos[1] = math.sin(viz.radians(90)*time+20*i) * 0.1
			p.setPointPos(i,pos)
	elif num == 1:
		#Change visibility of second column
		for i in range(50,100):
			p.setPointVisible(i,not p.getPointVisible(i))
	elif num == 2:
		#Change color of third column
		for i in range(100,150):
			color = [vizmat.GetRandom(0,1),vizmat.GetRandom(0,1),vizmat.GetRandom(0,1)]
			p.setPointColor(i,color)
viz.callback(viz.TIMER_EVENT,ontimer)
viz.starttimer(0,0,viz.FOREVER)
viz.starttimer(1,1,viz.FOREVER)
viz.starttimer(2,1,viz.FOREVER)
