﻿import viz
import vizcave

CAVE_WIDTH = 0.59773
CAVE_HEIGHT = 0.33622
DISTANCE = 0.70 


viz.setMultiSample(8)
viz.go(viz.FULLSCREEN)	
viz.clearcolor(0, 0, 0) 

PowerWall = vizcave.Wall(	upperLeft=[-CAVE_WIDTH/2.0, CAVE_HEIGHT/2.0, 0], 
							upperRight=[CAVE_WIDTH/2.0, CAVE_HEIGHT/2.0, 0], 
							lowerLeft=[-CAVE_WIDTH/2.0, -CAVE_HEIGHT/2.0, 0], 
							lowerRight=[CAVE_WIDTH/2.0, -CAVE_HEIGHT/2.0, 0]	)
							
cave = vizcave.Cave()
cave.addWall(PowerWall)
# creates a dummy-tracker (a group object is an empty node)
head_tracker = viz.addGroup( pos=[0, 0, -DISTANCE] ) 
cave.setTracker(head_tracker)
vizcave.CaveView(head_tracker)

board = viz.add('chessboard.OSGB')