﻿# (c)2016 Peter.Roesch@hs-augsburg.de

from __future__ import print_function, division
import viz
import vizcam
import vizshape
import vizact
import math
import numpy as np
import RobotModel
import vizconnect #ermöglicht Verwendung von vizconnect

viz.setMultiSample(4)
vizconnect.go('vizconnect_hand_config.py') 


   

viz.collision(viz.ON) 
#viz.MainView.setPosition([0,0,0])

def robot_follows_marker(robot, marker):
    robot_pos = robot.get_position()
    marker_pos = marker.getPosition()
    
    p = [   marker_pos[0] - robot_pos[0], 
            marker_pos[1] - robot_pos[1], 
            marker_pos[2] - robot_pos[2] ]
    
    ZF = np.array( [
        [0, 1, 0,  p[0]],
        [1, 0, 0, -p[2]],
        [0, 0, -1, p[1]],
        [0, 0, 0, 1]
        ], np.float32)
        
    robot.set_tool(ZF)
    
v = [0, 0, 0.25]
    
move_marker_forward = vizact.move(v, 2)
move_marker_backward = vizact.move([-v[0], -v[1], -v[2]], 2)
    

if __name__ == '__main__':
    CYCLES_PER_SEC      = 0.05
    viz.setMultiSample(4)
    viz.fov(60)
    viz.setOption('viz.max_frame_rate', 60)
    viz.vsync(viz.ON)
    viz.go()

    Heizung = viz.addChild('heiz.stl')
    Heizung.setPosition([2.2, 1.64, 3])
    ground = viz.addChild('ground_gray.osgb')
    #robot = RobotModel.LBR_Model(r'STL')
    #robot.set_position([2.2, 1.64, 3])
    
    #p = [2.5, 1.8, 3.2]
    
    #ball = viz.addChild('ball.wrl', scale=[0.1, 0.1, 0.1])
    #ball.setPosition(p[0], p[1], p[2])
    #sequence = vizact.sequence(
     #  [move_marker_forward, move_marker_backward,
      #      move_marker_backward, move_marker_forward],
       # viz.FOREVER)
    #ball.addAction(sequence)
    
    #vizact.ontimer(1./float(viz.getOption('viz.max_frame_rate')), 
     #   robot_follows_marker, robot, ball)
        
#Add shapes
pyramid = vizshape.addPyramid(base=(0.2,0.2),height=0.2,pos=[-0.5,1.7,1],alpha=0.7)
torus = vizshape.addTorus(radius=0.1,tubeRadius=0.015,axis=vizshape.AXIS_X, pos=[0,1.7,1])
box = vizshape.addCube(size=0.1, pos=[0.5,1.7,1],alpha=0.8)
pyramid.texture(viz.addTexture('images/tile_slate.jpg'))
torus.texture(viz.addTexture('images/tile_wood.jpg'))
shapes = [Heizung,pyramid,torus,box]

# Code to get the grabber tool by name and supply the list of items which can be grabbed 
grabber = vizconnect.getRawTool('grabber')
grabber.setItems(shapes)

scaleAction = vizact.sequence([vizact.sizeTo(size=[1.3,1.3,1.3],time=1),vizact.sizeTo(size=[1,1,1],time=1)], viz.FOREVER)
fadeAction = vizact.sequence([vizact.fadeTo([0.63,0.32,0.18],time=2),vizact.fadeTo(viz.WHITE,time=2)], viz.FOREVER)

def onGrab(e):
    if e.grabbed == torus:
        torus.runAction(fadeAction,pool=1)
    else:
        e.grabbed.runAction(scaleAction,pool=1)

def onRelease(e):
    e.released.endAction(pool=1)

from tools import grabber
viz.callback(grabber.GRAB_EVENT, onGrab)
viz.callback(grabber.RELEASE_EVENT, onRelease)