﻿import viz
import vizact
import viztask

viz.go()

quad = viz.addTexQuad(pos=[0,1.8,3])
video = viz.addVideo('info_video.mp4')
#video.play()
#video.stop()
quad.texture(video)

HighProbQueue = []

def CycleProblems():
	"""Cycle the problems waiting in HighProbQueue to be displayed"""
	global HighProbQueue
	while len(HighProbQueue) > 0:
		id = HighProbQueue.pop(0)
#		id = HighProbQueue.pop()
		yield viztask.waitTime( 1 )
#		FreezeAction(True)
		#play sound for video start
		playing = DisplayVideo(id)
		#timer might pause here, if there's a video playing (wait for 3 secs for fades)
		yield viztask.waitTime( playing * 3 )
		
def DisplayVideo(taskid):
	"""Display the video in Vizard and update all clients with a message"""
	high_info = {1:{'vtime':'[59.5,62]'}, 2: {'vtime':'[92.5,95]'}, 3: {'vtime': '[147,149]'}}
	print high_info[taskid], taskid
	playVideo = PlayVideo(high_info[taskid])
#	changeiPadPage('high_video')
	return playVideo
	
def PlayVideo(probInfo):
	videoTime= probInfo['vtime']
	if videoTime == "":	#no video for this task
		return False
#	self.QPanel.setPanelVisible(0)
	start = eval(videoTime)[0]
	end = eval(videoTime)[1]
	print "Play video from %s to %s" %(start, end)
	video.play()	#this has to be AFTER setTimeto avoid random jumping!!!
	video.setTime(start)
	video.stoptime(end)
#	self._bg.texture(self.video, '', 1)
#	fadeIn = vizact.mix(0, 1, time=1)
#	fadeOut = vizact.mix(1, 0, time=1)
#	self._bg.addAction(vizact.method.texblend(fadeIn,'',1))
#	self._bg.addAction(vizact.call(self.pauseTime, end - start)) #self._bg.addAction(vizact.waittime(end - start))
#	self._bg.addAction(vizact.method.texblend(fadeOut,'',1))
	return True
	
def scheduleProblem(id):
	"""Schedule the task id as a problem to be displayed by putting it in the HighProbQueue"""
	global HighProbQueue, activeProb
	HighProbQueue.append(id)	#enque the taskid
	try:
		if not activeProb.alive():	#check if there is any active problem alive
			activeProb = viztask.schedule(CycleProblems())	
	except NameError:	#the activeProb has not been created yet, so initialize it
		activeProb = viztask.schedule(CycleProblems())
	
vizact.onkeydown('1', scheduleProblem, 1) #video.setTime,59.5)
vizact.onkeydown('2', scheduleProblem, 2) #video.setTime,92.5)
vizact.onkeydown('3', scheduleProblem, 3) #video.setTime,147)
vizact.onkeydown('4',video.setTime,155.6)
vizact.onkeydown('5',video.setTime,162.5)
vizact.onkeydown('6',video.setTime,193)