import viz
viz.go()

#Add sky model
sky = viz.add('sky.osg')

#Add textures
horizon_tex = viz.add('horizon.png')
horizon_tex.wrap(viz.WRAP_S,viz.CLAMP_TO_EDGE)
horizon_tex.wrap(viz.WRAP_T,viz.CLAMP_TO_EDGE)
cloud_tex = viz.add('clouds.png')
cloud_tex.wrap(viz.WRAP_S,viz.REPEAT)
cloud_tex.wrap(viz.WRAP_T,viz.REPEAT)

#Apply textures to sky
sky.texture(horizon_tex,'',0)
sky.texture(cloud_tex,'',1)

#Add shaders
sky_vp = viz.add('sky.vp')
sky_fp = viz.add('sky.fp')

#Apply shaders to sky
sky.apply(sky_vp)
sky.apply(sky_fp)

viz.clearcolor(viz.GRAY)
viz.fov(70,1.3)

sky.translate(0,-400,0)

CLOUD_SPEED = 1.0

def ontimer(num):
	sky_vp.param(0,viz.get(viz.FRAME_TIMESTAMP)*CLOUD_SPEED)

viz.callback(viz.TIMER_EVENT,ontimer)
viz.starttimer(0,0,viz.FOREVER)

viz.add('tut_ground.wrl')
