# Script for understanding rotations
import viz 
viz.go()

#Variable for rotation
rotation = 0

# Load the VRML geometry files here
g = viz.add('tut_ground.wrl')
c = viz.add('tut_cone.wrl')
s = viz.add('tut_sphere.wrl')
b = viz.add('tut_box.wrl')  
h = viz.add('tut_hedra.wrl')

#Object h (tut_hedra.wrl) would be located at the origin (directly under the initial viewpoint)
#and needs to be translated 7m to the front (along the positive z - axis) to be nicely visible
h.translate(0,0,6)

# Callback function to handle expiration timers
def mytimer(num):
	global rotation
	h.rotate(0, 1, 0,rotation)
	rotation = rotation + 1

	# start a new timer which starts the function 'mytimer' as quickly as possible
	# (==> endless loop with maximum speed)    
	viz.starttimer()

# One-time setup of callback event, here the TIMER_EVENT starts the callback function 'mytimer'
viz.callback(viz.TIMER_EVENT, mytimer)

def mykeyboard(whichKey):
	print 'The following key was pressed: ', whichKey
	if whichKey == 'a':
		h.curtain(1)
	if whichKey == 'b':
		h.curtain(0)

viz.callback(viz.KEYBOARD_EVENT, mykeyboard)

# Now a first TIMER_EVENT is started (like an alarm clock) which expires as quickly as possible and then calls
# the function 'mytimer' as defined before
viz.starttimer()


