﻿import csv
import viz
import vizfx
import vizconnect
import vizact
import makingCSVFile


import vizmat
import viztask
import vizshape
import zspace
import vizinfo
import vizinput
import viznet


class ExplosiveModel(viz.VizNode):
	""" creates a model with a given dae file and gets parts and moves them on specified axes """

	def __init__(self, rowData):
		self.isu = vizfx.addChild('RC_MET_ISU.dae')
		viz.VizNode.__init__(self, self.isu.id)
		self.scale = .035125 #this scale is determined by doc (dividing model size by .035, we get desired size)
		self.isu.setScale([self.scale]*3)
		self.current = 0 #index of current
		self.rowData = rowData[:]
		self.layerParents = []
		self.partDict = {}
		

	def getNextPart(self):
		""" returns the axis, distance away, and parts names of the next step """
		self.current += 1
		print "get part", self.rowData[self.current][0], self.rowData[self.current][1]
		return self.rowData[self.current][0], self.rowData[self.current][1], self.rowData[self.current][2]

	def reset(self):
		for part in self.partDict.values():
			part.setParent(self)
			part.setMatrix(part.originalMatrix, viz.ABS_GLOBAL)
		for layerParent in self.layerParents:

			layerParent.remove()
		self.layerParents = []
		self.current = 0

	def returnPreviousPartLayer(self):
		if self.current < 0:
			return
		try:
  			currentNames = self.rowData[self.current][2]
			for childName in currentNames:
				part = self.partDict[childName]
				part.setParent(self)
				part.setMatrix(part.originalMatrix, viz.ABS_GLOBAL)
			self.current = max(0, self.current-1)
			# remove the layer parent
			layerParent = self.layerParents.pop(-1)
		
			layerParent.remove()
		except KeyError:
			pass

	def movePart(self, part, vector, distance):
		""" moves a part along a unit vector to a given distance."""
		mat = vizmat.Transform()
		#model orientation determines expansion direction
		mat.setQuat(self.getQuat(viz.ABS_GLOBAL))
		#model scale still scales distance uniformly and ignoring initial scale
		mat.setScale([self.getScale(viz.ABS_GLOBAL)[0]/0.035125]*3)
		vector = vector * float(distance)
		vector = mat.preMultVec(vector)
		#component wise subtract the unit vector from one to
		#determine which portions of the position we use. We don't
		#just add to position, as all of the pieces are meant to go
		#to the same distance along the given unit vector.
		pos = part.getPosition(viz.ABS_GLOBAL)
		vector += [
			(1.0 - vector[0])*pos[0],
			(1.0 - vector[1])*pos[1],
			(1.0 - vector[2])*pos[2],
		]
		part.setPosition(vector, viz.ABS_GLOBAL)

	def moveNextPartLayer(self):
		""" based on the axis of movement, next parts are moved along the distance specified """
		try:
			axis, nextDistance, nextNames  = self.getNextPart()

			print "next Names", nextNames
			print "ax", axis
			print nextNames, int(nextDistance)
			#move next part nextName to distance nextDistance away from the object
			print nextNames[0]
			#set next layer
			layerParent = viz.addGroup()
			for partName in nextNames:
				if partName in self.partDict:
					part = self.partDict[partName]
				else:
					part = self.isu.getChild(partName)
					part.originalMatrix = part.getMatrix(viz.ABS_GLOBAL)
					self.partDict[partName] = part
				if axis == 'x':
					vector = vizmat.Vector([1, 0, 0])
				elif axis == 'y':
					vector = vizmat.Vector([0, 1, 0])
				elif axis == 'z':
					vector = vizmat.Vector([0, 0, 1])
				self.movePart(part, vector, float(nextDistance))
				#reparent the part to the layer
				mat = part.getMatrix(viz.ABS_GLOBAL)
				part.setParent(layerParent)
				part.setMatrix(mat, viz.ABS_GLOBAL)
			self.layerParents.append(layerParent)
			#add items to the grabber
		
		except IndexError:
			pass


viz.setMultiSample(8)
viz.clearcolor(viz.SLATE)

	#initialize zSpace display
display = zspace.init()

	#Scale up the zSpace display to avoid having to
	#scale down all the models to fit within the display viewport
display.setScale(200)

viz.startLayer(viz.LINES)
viz.vertex([0,0,0])
viz.vertex([0,0,1])
pointerLine = viz.endLayer(parent=display.getWandRoot())
pointerLine.lineWidth(2)
pointerTip = vizshape.addSphere(radius=0.5, parent=display.getWandRoot())
pointerTip.disable(viz.INTERSECTION)

def updatePointer():
			
	line = display.getWandLine()
	info = viz.intersect(line.begin, line.end, ignoreBackFace=True)
	color = viz.RED
	end = info.point
	pointerLine.color(color)
	pointerTip.color(color)
	dist = vizmat.Distance(line.begin,end)
	pointerLine.setScale([1,1,dist])
	pointerTip.setPosition([0,0,dist])
		


pointerUpdater = vizact.onupdate(0,updatePointer)
def GrabTask():
	global GrabedObject
		#//This task implements the grabbing interaction with the stylus
	while True:
		yield viztask.waitSensorDown(zspace.getWandTracker(), 0 )
			#//Intersect wand with scene
		line = display.getWandLine()
		info = viz.intersect(line.begin, line.end, ignoreBackFace=True)
			#~ if info.object in grabItems:
			#//Grab intersected object

		grabLink = viz.grab(display.getWandRoot(), info.object, srcFlag=viz.ABS_GLOBAL, dstFlag=viz.ABS_GLOBAL)
		GrabedObject=info.object
			
		
		'''GrabedObject.enable(viz.BLEND)
			
			GrabedObject.drawOrder(10,bin=viz.BIN_TRANSPARENT)'''
			
			#pointerUpdater.setEnabled(False)
			#info.object.setScale([1,1,2])
			#//Release object on button release
		yield viztask.waitSensorUp(zspace.getWandTracker(), 0 )
		grabLink.remove()
		pointerUpdater.setEnabled(True)
				
#___________________________________________________________________________________
#-----------------------------------------------------------------------------------
def ScalingBig():
	global GrabedObject
	if GrabedObject !=None:
		GrabedObject.setScale([GrabedObject.getScale()[0]/100+GrabedObject.getScale()[0],GrabedObject.getScale()[1]/100+GrabedObject.getScale()[1],GrabedObject.getScale()[2]/100+GrabedObject.getScale()[2]])
		
vizact.onkeydown('s', ScalingBig)	
#___________________________________________________________________________________
#-----------------------------------------------------------------------------------
def ScalingSmal():
	global GrabedObject
	if GrabedObject !=None:
		if GrabedObject.getScale()[0]-(GrabedObject.getScale()[0]/100)>0:
			GrabedObject.setScale([-GrabedObject.getScale()[0]/100+GrabedObject.getScale()[0],-GrabedObject.getScale()[1]/100+GrabedObject.getScale()[1],-GrabedObject.getScale()[2]/100+GrabedObject.getScale()[2]])
		
vizact.onkeydown('a', ScalingSmal)	
#___________________________________________________________________________________
#-----------------------------------------------------------------------------------
	
	#save handle to wand tracker
#wandTracker = zspace.getWandTracker()
#wandTracker.setLedEnabled(True)
	

#You could initialize the zspace using the code in the function initZSpace()
#since we're using grabbing, though, we'll use a vizconnect configuration
vizconnect.go('zspace_config.py') #zspace vizconnect setup
#alternatively, you could use the desktop                               
#vizconnect.go('vizconnect_desktop.py') #desktop vizconnect setup

rowData = []
#read csv data for part numbers per step
with open('names.csv', 'rb') as csvfile:
	reader = csv.reader(csvfile)
	for row in reader:
		rowData.append([row[0], row[1], row[2].split()])
print rowData

model = ExplosiveModel(rowData)
#model.setScale([0.001]*3)
vizact.onkeydown(' ', model.moveNextPartLayer) #on spacebar keypress, a layer explodes
vizact.onkeydown(viz.KEY_CONTROL_L, model.returnPreviousPartLayer)

viz.clearcolor(viz.GRAY) #change background color if desired

vizact.onkeydown('r', model.reset)
#___________________________________________________________________________________
#-----------------------------------------------------------------------------------
UPDATE = viznet.id('update')

CLIENT_DISCONNECTED = viznet.id('client_disconnected')

viznet.server.start(port_in=14950,port_out=14951)
#___________________________________________________________________________________
#-----------------------------------------------------------------------------------
def onStartClient(e):
    print '** Client joined:',e.sender
viz.callback(viznet.CLIENT_CONNECT_EVENT,onStartClient)
#___________________________________________________________________________________
#-----------------------------------------------------------------------------------
def onStopClient(e):
    print '** Client left:',e.sender
    viznet.server.send(CLIENT_DISCONNECTED,client=e.sender) #//Alert other clients
    objects[e.sender].remove() 
    del objects[e.sender] #//Delete user from array
viz.callback(viznet.CLIENT_DISCONNECT_EVENT,onStopClient)

def update(e):
	global grabItems,models, filePath
	global ModelsList,logoss1,DissasembeldPart,Listchilderen, xmodel
	try:
		
		
		if e.DisAssPart==True and DissasembeldPart==False:
			
			
			for i in Listchilderen:
				if i.startswith("Inst"):
					xmodel=logoss1.getChild(i)
					
					ModelsList.append(xmodel)
											
			print "ModelsList------------------------",ModelsList
			models = viz.cycle(ModelsList)
			grabItems = set(models)
			print "----------e.GrabObj",e.GrabObj
			DissasembeldPart=True
			e.GrabObj.setPosition(e.pos)
			e.GrabObj.setEuler(e.ori)
			
		elif e.DisAssPart==False and DissasembeldPart==True:
			
			for i1 in ModelsList:
				i1.remove()
			logoss1.remove()
			logoss1 = viz.add(filePath)
			logoss1.setPosition([0,0,0])
			logoss1.setScale([0.1,0.1,0.1])
			print "????????????????", ModelsList
			models = viz.cycle([logoss1])
			grabItems = set(models)
			DissasembeldPart=False
			print "----------e.GrabObj",e.GrabObj
			e.GrabObj.setPosition(e.pos)
			e.GrabObj.setEuler(e.ori)
			
		else:
			print "----------e.GrabObj",e.GrabObj
			e.GrabObj.setPosition(e.pos)
			e.GrabObj.setEuler(e.ori)
			
			
	except KeyError: #//If key doesn't exist add the user's object
		print 'erorrrr add'
	#print '-------------update server' 
viz.callback(UPDATE,update)
#___________________________________________________________________________________
#-----------------------------------------------------------------------------------

#//Tool Tip
import viztip
tth = viztip.ToolTip()
tth.start()
tth.setDelay(0)
#___________________________________________________________________________________
#-----------------------------------------------------------------------------------
def MainTask():

	#//Start model grab task
	yield GrabTask()
	
viztask.schedule( MainTask() )
#___________________________________________________________________________________
#-----------------------------------------------------------------------------------