﻿import viz
import vizconnect
import vizproximity


viz.setMultiSample(4)
viz.fov(60)

SPEED = 12,000
MODE = viz.SPEED
ROTATE_MODE = viz.NO_ROTATE

print 'Xenium LAB : welcome screen' 
#--------------------------------Stereo effects----------#
vizconnect.go('./welcomeDetails/welcome_vizconnect_config.py')


#Add pivot camera
import vizcam
cam = vizcam.PivotNavigate(distance=20)
cam.rotateUp(15)

def addBackgroundQuad(scene=viz.MainScene):
    """Returns a quad that will display in the background of the scene"""

    #Create group node containing render nodes for left/right eye quads
    group = viz.addGroup(scene=scene)
    group.leftQuad = viz.addRenderNode()
    group.leftQuad.disable(viz.RENDER_RIGHT)
    group.rightQuad = viz.addRenderNode()
    group.rightQuad.disable(viz.RENDER_LEFT)
    
    #Setup render nodes to display behind scene
    nodes = viz.ObjectGroup([group.leftQuad,group.rightQuad])
    nodes.setHUD(-1,1,-1,1,True)
    nodes.setOrder(viz.MAIN_RENDER)
    nodes.parent(group)
    group.drawOrder(-10000)
    group.polyMode(viz.POLY_FILL)
    
    return group


#Create background quad and apply a texture
background = addBackgroundQuad()
texture = viz.add('./welcomeDetails/screensaver.jpg')
background.texture(texture)

vrpn = viz.add('vrpn7.dle') 
tracker = vrpn.addButton('PPT_WAND3@192.168.99.1:8945')



class MySensorDowntEventClass(viz.EventClass): 
    def __init__(self): 
        #IMPORTANT: We need to initialize base class 
        viz.EventClass.__init__(self) 
        #Register callback with our event class 
        self.count = 1  # Mouse click count
        self.callback(viz.SENSOR_DOWN_EVENT, self.onButtonDown)  
         
    def onButtonDown(self,e):
     print e.button, ' welcom button down'
     if e.object is tracker: 
      if(e.button==5):
       #
       if self.count==1:  
        print 'tracker 5 welcom button down'
        removeModels() 
        loadTopView()
       if self.count==2:
        removeModels()
        loadFloorView()
       if self.count==3:
        removeModels()        
        loadClubHouse()
        self.count=1
       self.count += 1 # Update count  
       print'the count variable value after  increment ',self.count

wel=MySensorDowntEventClass() 


#method for loading topview

def loadTopView():
	 vizconnect.go('./runwallModels/runwallVizconnect/top_vizconnect_config.py')
	 viz.MainWindow.ipd(-1000)
	 viz.MainWindow.screenDistance(1.00)
	 viz.MainWindow.fusionDistance(4.61)
	 runwall1=viz.add('./runwallModels/All_levels.OSGB')
	 oriMode = vizconnect.VIEWPOINT_MATCH_DISPLAY
	 posMode = vizconnect.VIEWPOINT_MATCH_FEET
	 vp1=vizconnect.addViewpoint(pos=[-3831,277994.55,-727484.34],euler=[0, 60, 0],posMode=posMode,oriMode=oriMode,constant=False,)
	 vp1.add(vizconnect.getDisplay())
	 club1=runwall1.getChild('Clubhouse_01');
	 club2=runwall1.getChild('Clubhouse_02');
	 club3=runwall1.getChild('Clubhouse_03');
	 club4=runwall1.getChild('Clubhouse_04');
	 club5=runwall1.getChild('Clubhouse_05');
	 club6=runwall1.getChild('Clubhouse_06');
	 club7=runwall1.getChild('Clubhouse_007');
	 hosp=runwall1.getChild('hospital')
	 school=runwall1.getChild('School')
	 mall=runwall1.getChild('Mall')
	 #Add main viewpoint as proximity target
	 target = vizproximity.Target(vizconnect.getTransport().getNode3d())
	 #creating the manager for the proximity area for the runwal building complex		
	 manager=vizproximity.Manager()
	 #Creating the colour
	 manager.setDebug(viz.ON)
	 manager.setDebugColor(viz.GREEN)
	 #Creating & registering  sensors for all clubhouses
	 #runWalcomplexSensor = vizproximity.Sensor(vizproximity.Box([1000000,200000,800000],center=[0,1.3,1]),source=runwall1)
	 #manager.addSensor(runWalcomplexSensor)
	 sensorClubHouse1 = vizproximity.Sensor(vizproximity.Box([13591.67,9186.81,28841.91],center=[51272.26,4681.00,178442.50]),source=club1)
	 manager.addSensor(sensorClubHouse1)
	 sensorClubHouse2 = vizproximity.Sensor(vizproximity.Box([13518.25,9127.62,28841.91],center=[69962.64,4681.00,-177074.58]),source=club2)
	 manager.addSensor(sensorClubHouse2)
	 sensorClubHouse3 = vizproximity.Sensor(vizproximity.Box([14552.59,9131.26,29623.28],center=[-63413.98,4681.00,2448.66]),source=club3)
	 manager.addSensor(sensorClubHouse3)
	 sensorClubHouse4 = vizproximity.Sensor(vizproximity.Box([14890.70,9155.84,29525.28],center=[62773.91,4681,2803.70]),source=club4)
	 manager.addSensor(sensorClubHouse4)
	 sensorClubHouse5 = vizproximity.Sensor(vizproximity.Box([16570.46,9162.92,30152.39],center=[-51450.15,4681,178491.45]),source=club5)
	 manager.addSensor(sensorClubHouse5)
	 sensorClubHouse6 = vizproximity.Sensor(vizproximity.Box([16389.11,9123.46,30140.61],center=[51272.26,4681,178442.50]),source=club6)
	 manager.addSensor(sensorClubHouse6)
	 sensorClubHouse7 = vizproximity.Sensor(vizproximity.Box([28841.91,9186.81,13591.66],center=[-92280.31,4605.55,-453904.5]),source=club7)
	 manager.addSensor(sensorClubHouse7)
	 #Creating & registering  the hospital sensor
	 hospitalSensor = vizproximity.Sensor(vizproximity.Box([74107.16,39558.20,54223.2],center=[126213.61,19619.82,-492704]),source=hosp)
	 manager.addSensor(hospitalSensor)
	 #Creating & registering the mall sensor
	 mallSensor = vizproximity.Sensor(vizproximity.Box([78677.09,15402.26,87339.7],center=[62107.18,8148.20,381100.28]),source=mall)
	 manager.addSensor(mallSensor)
	 #Creating & registering the school sensor
	 schoolSensor = vizproximity.Sensor(vizproximity.Box([81019.11,44659.84,32478.1],center=[37183.59,22205.15,-325754.9]),source=school)
	 manager.addSensor(schoolSensor)
	 #Setting the target for the proximity
	 manager.addTarget(target)
	 #Toggle debug shapes with keypress
	 vizact.onkeydown('d',manager.setDebug,viz.TOGGLE)
	 #Proximity callback function that records if the user has entered the proximity of an avatar.
	 #Entering avatar proximity indicates the user did not avoid the avatar and sets the corresponding
	 #trial variable to False
	 def EnterProximity(e):
	   """@args vizproximity.ProximityEvent()"""
	   #global avoidSitting,avoidStanding,avoidDancing
	   if e.sensor == runWalcomplexSensor:
	     manager.setDebugColor(viz.GREEN)
	   elif e.sensor == hospitalSensor:
	     print 'I m in hospital sensor'
	   elif e.sensor == schoolSensor:
	     print 'I m in school sensor'
	 manager.onEnter(None,EnterProximity)


def loadFloorView():
     vizconnect.go('./FloorVizconnect/vizconnect_config.py')
     viz.MainWindow.ipd(-1000)
     viz.MainWindow.screenDistance(1.00)
     viz.MainWindow.fusionDistance(4.61)
     runwall2=viz.add('./runwallModels/All_levels.OSGB')
     oriMode = vizconnect.VIEWPOINT_MATCH_DISPLAY
     posMode = vizconnect.VIEWPOINT_MATCH_FEET

# Add a viewpoint.                                      x        y            z
     vp = vizconnect.addViewpoint(pos=[-32736,6103.35,-44466.08],euler=[0, 0, 0],posMode=posMode,oriMode=oriMode,constant=False,)
     vp.add(vizconnect.getDisplay())
     club1=runwall2.getChild('Clubhouse_01');
     club2=runwall2.getChild('Clubhouse_02');
     club3=runwall2.getChild('Clubhouse_03');
     club4=runwall2.getChild('Clubhouse_04');
     club5=runwall2.getChild('Clubhouse_05');
     club6=runwall2.getChild('Clubhouse_06');
     club7=runwall2.getChild('Clubhouse_007');
     hosp=runwall2.getChild('hospital')
     school=runwall2.getChild('School')
     mall=runwall2.getChild('Mall')
    #Add main viewpoint as proximity target
     target = vizproximity.Target(vizconnect.getTransport().getNode3d())
    #creating the manager for the proximity area for the runwal building complex		
     manager=vizproximity.Manager()
    #Creating the colour
     manager.setDebug(viz.ON)
     manager.setDebugColor(viz.GREEN)
   
     sensorClubHouse1 = vizproximity.Sensor(vizproximity.Box([13591.67,9186.81,28841.91],center=[51272.26,4681.00,178442.50]),source=club1)
     manager.addSensor(sensorClubHouse1)

     sensorClubHouse2 = vizproximity.Sensor(vizproximity.Box([13518.25,9127.62,28841.91],center=[69962.64,4681.00,-177074.58]),source=club2)
     manager.addSensor(sensorClubHouse2)

     sensorClubHouse3 = vizproximity.Sensor(vizproximity.Box([14552.59,9131.26,29623.28],center=[-63413.98,4681.00,2448.66]),source=club3)
     manager.addSensor(sensorClubHouse3)
   
     sensorClubHouse4 = vizproximity.Sensor(vizproximity.Box([14890.70,9155.84,29525.28],center=[62773.91,4681,2803.70]),source=club4)
     manager.addSensor(sensorClubHouse4)

     sensorClubHouse5 = vizproximity.Sensor(vizproximity.Box([16570.46,9162.92,30152.39],center=[-51450.15,4681,178491.45]),source=club5)
     manager.addSensor(sensorClubHouse5)
     sensorClubHouse6 = vizproximity.Sensor(vizproximity.Box([16389.11,9123.46,30140.61],center=[51272.26,4681,178442.50]),source=club6)
     manager.addSensor(sensorClubHouse6)
     sensorClubHouse7 = vizproximity.Sensor(vizproximity.Box([28841.91,9186.81,13591.66],center=[-92280.31,4605.55,-453904.5]),source=club7)
     manager.addSensor(sensorClubHouse7)
     #End of the sensors of the club houses
     #Creating & registering  the hospital sensor
     hospitalSensor = vizproximity.Sensor(vizproximity.Box([74107.16,39558.20,54223.2],center=[126213.61,19619.82,-492704]),source=hosp)
     manager.addSensor(hospitalSensor)
     #Creating & registering the mall sensor
     mallSensor = vizproximity.Sensor(vizproximity.Box([78677.09,15402.26,87339.7],center=[62107.18,8148.20,381100.28]),source=mall)
     manager.addSensor(mallSensor)
    #Creating & registering the school sensor
     schoolSensor = vizproximity.Sensor(vizproximity.Box([81019.11,44659.84,32478.1],center=[37183.59,22205.15,-325754.9]),source=school)
     manager.addSensor(schoolSensor)
   #Setting the target for the proximity
     manager.addTarget(target)
    #Toggle debug shapes with keypress
     vizact.onkeydown('d',manager.setDebug,viz.TOGGLE)
   #Proximity callback function that records if the user has entered the proximity of an avatar.
#Entering avatar proximity indicates the user did not avoid the avatar and sets the corresponding
#trial variable to False
     def EnterProximity(e):
       removeModelsFloorView()
       print 'inside proximity'
       if e.sensor == sensorClubHouse1:
           print 'I m in clubhouse 1 sensor'
           import clubHouse
       elif e.sensor == sensorClubHouse2:
           print 'I m in clubhouse 2 sensor'
           import clubHouse
       elif e.sensor == sensorClubHouse3:
           print 'I m in clubhouse 3 sensor'
           import clubHouse
       elif e.sensor == sensorClubHouse4:
           print 'I m in clubhouse 4 sensor'
           import clubHouse
       elif e.sensor == sensorClubHouse5:
           print 'I m in clubhouse 5 sensor'
           import clubHouse
       elif e.sensor == sensorClubHouse6:
           print 'I m in clubhouse 6 sensor'
           import clubHouse
       elif e.sensor == sensorClubHouse7:
           print 'I m in clubhouse 7 sensor'
           import clubHouse
       elif e.sensor == schoolSensor:
           print 'I m in hospital sensor'
           import school
       elif e.sensor == mallSensor:
           print 'I m in hospital sensor'
           import mall
       elif e.sensor == hospitalSensor:
           print 'I m in hospital sensor'
           import hospital
     manager.onEnter(None,EnterProximity)




#Load clubHouse from floor view
def loadClubHouse():
     vizconnect.go('./modelChange/modelchange_vizconnect_config2.py')
     club=viz.add('./amenities/Clubhouse.osgb')
     club.appearance(viz.TEXNEAREST)
     oriMode = vizconnect.VIEWPOINT_MATCH_DISPLAY
     posMode = vizconnect.VIEWPOINT_MATCH_FEET
     # Add a viewpoint.
     vp3 = vizconnect.addViewpoint(	pos=[0,0,0],euler=[0, 0, 0],posMode=posMode,oriMode=oriMode,constant=False,)
     vp3.add(vizconnect.getDisplay())

#Load hospital from floor view
def loadHospital():
	viz.ipd(0.01)
	vizconnect.go('./modelChange/modelchange_vizconnect_config2.py')
	hospitl=viz.add('./amenities/Hospital_1.osgb')
	oriMode = vizconnect.VIEWPOINT_MATCH_DISPLAY
	posMode = vizconnect.VIEWPOINT_MATCH_FEET
	# Add a viewpoint.
	vp4 = vizconnect.addViewpoint(pos=[33,2,29],euler=[0, 0, 0],posMode=posMode,oriMode=oriMode,constant=False,)
	vp4.add(vizconnect.getDisplay())
	
#Load school from floor view	
def loadSchool():
	vizconnect.go('./modelChange/modelchange_vizconnect_config2.py')
	schoolll=viz.add('./amenities/school_interior.osgb')
	schoolll.appearance(viz.TEXNEAREST)
	oriMode = vizconnect.VIEWPOINT_MATCH_DISPLAY
	posMode = vizconnect.VIEWPOINT_MATCH_FEET
	# Add a viewpoint.
	vp5= vizconnect.addViewpoint(pos=[7.86,2.2,-17.56],euler=[0, -7, 0],posMode=posMode,oriMode=oriMode,constant=False)
	vp5.add(vizconnect.getDisplay())
	
#Load mall from floor view	
def loadMall():
	vizconnect.go('./modelChange/modelchange_vizconnect_config2.py')
	mallll=viz.add('./modelChange/models/dojo.osgb')
	oriMode = vizconnect.VIEWPOINT_MATCH_DISPLAY
	posMode = vizconnect.VIEWPOINT_MATCH_FEET
	# Add a viewpoint.
	vp6 = vizconnect.addViewpoint(pos=[0,0,0],euler=[0, 0, 0],posMode=posMode,oriMode=oriMode,constant=False,)
	vp6.add(vizconnect.getDisplay())
	
	
	
	
	
	
	
def removeModels():
    children = viz.MainScene.getChildren()
    for child in children:
      child.remove()

