import viz
viz.go()

viz.clearcolor(viz.SKYBLUE)

SIZE = 50
SPACING = 0.1
BOTTOM_COLOR = [1,0,0]
TOP_COLOR = [0,0,0]

#import kgarr module
import kgarr

#Create a height field that is SIZE x SIZE
hf = kgarr.HeightField(SIZE,SIZE)

#Set height of column 2, row 0 to 1
hf.setHeight(2,0,1)

#Set spacing between columns and rows
hf.setSpacing(SPACING,SPACING)

#Generate 2D array of random height and color values
import csv
height = [ [float(val) for val in row] for row in csv.reader(file('data.txt','rUb')) ]

def generateColors(beginColor,endColor,heightMap):
	
	#Get lowest/highest height values
	minHeight = min( [ min(column) for column in heightMap] )
	maxHeight = max( [ max(column) for column in heightMap] )

	def GetColor(h):
		return vizmat.Interpolate(BOTTOM_COLOR,TOP_COLOR, (h - minHeight) / (maxHeight - minHeight))
	
	#Generate color values
	return [ [ GetColor(h) for h in column] for column in heightMap ]

color = generateColors(BOTTOM_COLOR,TOP_COLOR,height)

#Apply array to entire height field
hf.setHeight(height)

#Apply color array to height field
hf.setColor(color)

#Disable lighting
hf.disable(viz.LIGHTING)

#Create wire frame version of height field
wireHF = kgarr.HeightField(SIZE,SIZE)
wireHF.setSpacing(SPACING,SPACING)
wireHF.setHeight(height)
wireHF.color(viz.BLACK)
wireHF.renderWire() #default render mode is hf.renderPolygon(), can also render as points using hf.renderPoint()
wireHF.disable(viz.LIGHTING)
wireHF.zoffset(-1)

#Place height fields in front of user
hf.translate(-3,1,8)
wireHF.translate(-3,1,8)