"""
This module was generated by Vizconnect.
Version: 1.02
Generated on: 2015-09-04 13:19:51.143000
"""

import viz
import vizconnect

#################################
# Parent configuration, if any
#################################

def getParentConfiguration():
	#VC: set the parent configuration
	_parent = ''
	
	#VC: return the parent configuration
	return _parent


#################################
# Pre viz.go() Code
#################################

def preVizGo():
	return True


#################################
# Pre-initialization Code
#################################

def preInit():
	"""Add any code here which should be called after viz.go but before any initializations happen.
	Returned values can be obtained by calling getPreInitResult for this file's vizconnect.Configuration instance."""
	return None


#################################
# Group Code
#################################

def initGroups(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawGroup = vizconnect.getRawGroupDict()

	#VC: initialize a new group
	_name = 'corner_cave_manual_configuration_single_machine'
	if vizconnect.isPendingInit('group', _name, initFlag, initList):
		#VC: init the raw object
		if initFlag&vizconnect.INIT_RAW:
			#VC: create the raw object
			rawGroup[_name] = viz.addGroup()
	
		#VC: init the wrapper (DO NOT EDIT)
		if initFlag&vizconnect.INIT_WRAPPERS:
			vizconnect.addGroup(rawGroup[_name], _name, make='Virtual', model='Origin')
	
		#VC: set the parent of the node
		if initFlag&vizconnect.INIT_PARENTS:
			vizconnect.getGroup(_name).setParent(vizconnect.getTransport('mytransport_wandmagiccarpet'))

	#VC: return values can be modified here
	return None


#################################
# Display Code
#################################

def initDisplays(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawDisplay = vizconnect.getRawDisplayDict()

	#VC: initialize a new display
	_name = 'corner_cave_manual_configuration_single_machine'
	if vizconnect.isPendingInit('display', _name, initFlag, initList):
		#VC: init which needs to happen before viz.go
		if initFlag&vizconnect.INIT_PREVIZGO:
			viz.setOption('viz.stereo', viz.QUAD_BUFFER)
	
		#VC: init the raw object
		if initFlag&vizconnect.INIT_RAW:
			#VC: set the window for the display
			_window = viz.MainWindow
			
			#VC: set the fullscreen monitor
			viz.window.setFullscreenMonitor(0)
			viz.window.setFullscreen(True)
			
			#VC: set some parameters
			rightWall = 2
			leftWall = -1
			frontImageWidth = 2
			imageHeight = 2
			imageRise = 0.1
			originLeft = 1.4142
			originRight = 1.4142
			sideImageWidth = 0
			shiftRight = 0
			shiftUp = 0
			shiftForward = 0
			stereo = viz.QUAD_BUFFER
			
			#VC: create the raw object
			# fix front wall to be at middle
			frontWall = 1
			
			# get an origin node
			originName = _name
			initGroups(vizconnect.INIT_INDEPENDENT, [originName])# ensure it's been created
			originNode = vizconnect.getGroup(originName).getNode3d()
			
			# Create a cave object
			import vizcave
			cave = vizcave.Cave(stereo=stereo)
			
			if sideImageWidth == 0:
				sideImageWidth = frontImageWidth
			
			# get the originLeft angle from the origin measurements
			import math
			aOR = math.pi/4.0
			aAOR = (originRight**2 - originLeft**2 - frontImageWidth**2)/(-2*originLeft*frontImageWidth)
			if abs(aAOR) <= 1:
				aOR = math.acos(aAOR)
			
			# convert the angle to front and right shifts
			Sr =-(math.cos(aOR)*originLeft-frontImageWidth/2.0)
			Sf = (math.sin(aOR)*originLeft-sideImageWidth/2.0)
			
			# find left/right, up/down, front/back (x,y,z) extent of caves
			R = frontImageWidth/2.0+Sr+shiftRight# right
			L =-frontImageWidth/2.0+Sr+shiftRight# left
			U = imageRise+imageHeight+shiftUp# up/top
			D = imageRise+shiftUp# bottom/down
			F = sideImageWidth/2.0+Sf+shiftForward# front
			B =-sideImageWidth/2.0+Sf+shiftForward# back
			
			# find corners
			# e.g.
			# Front Wall: C1,C2,C5,C6
			# Left  Wall: C0,C1,C4,C5
			# Right Wall: C2,C3,C6,C7
			C0 = L, U, B
			C1 = L, U, F
			C2 = R, U, F
			C3 = R, U, B
			C4 = L, D, B
			C5 = L, D, F
			C6 = R, D, F
			C7 = R, D, B
			
			# get the number of windows
			layout = [0]*3
			map = [0]*(3+1)
			windowCount = 0
			for i in [leftWall, frontWall, rightWall]:
				map[i] = 1
			
			for i in range(0, 3):
				if map[i] > 0:
					layout[i] = float(windowCount)
					windowCount += 1
			
			windowSize = [1.0/windowCount,1.0]
			windowList = []
			
			#Create front wall
			frontWindow = _window
			frontWindow.setSize(windowSize)
			frontWindow.setView(viz.MainView)# set to default so it can be overridden later on by cave setup
			frontWindow.setPosition([layout[frontWall]/windowCount, 1])
			windowList.append(frontWindow)
			
			wall = vizcave.Wall(	upperLeft=C1,
									upperRight=C2,
									lowerLeft=C5,
									lowerRight=C6,
									name='Front Wall' )
			
			cave.addWall(wall, window=frontWindow)
			
			#Create right wall
			if rightWall >= 0:
				rightWindow = viz.addWindow(size=windowSize, pos=[layout[rightWall]/windowCount,1])
				wall = vizcave.Wall(	upperLeft=C2,
										upperRight=C3,
										lowerLeft=C6,
										lowerRight=C7,
										name='Right Wall' )
				
				cave.addWall(wall, window=rightWindow)
				windowList.append(rightWindow)
				if '_clusterMask' in locals():
					with viz.cluster.MaskedContext(viz.ALLCLIENTS&~_clusterMask):# hide
						rightWindow.visible(False)
					with viz.cluster.MaskedContext(_clusterMask):# show
						rightWindow.visible(True)
			
			#Create left wall
			if leftWall >= 0:
				leftWindow = viz.addWindow(size=windowSize, pos=[layout[leftWall]/windowCount,1])
				wall = vizcave.Wall(	upperLeft=C0,
										upperRight=C1,
										lowerLeft=C4,
										lowerRight=C5,
										name='Left Wall' )
				
				cave.addWall(wall, window=leftWindow)
				windowList.append(leftWindow)
				if '_clusterMask' in locals():
					with viz.cluster.MaskedContext(viz.ALLCLIENTS&~_clusterMask):# hide
						leftWindow.visible(False)
					with viz.cluster.MaskedContext(_clusterMask):# show
						leftWindow.visible(True)
			
			# We need to pass an object which will be used to update the projection
			# or the display to the view's position, typically this would be the
			# node attached to an avatar's head tracker. 
			viewpoint = viz.addGroup()
			cave.setTracker(viewpoint)
			
			# Create a CaveView object for manipulating the entire cave environment.
			# The caveView is a node that can be adjusted to move the entire 
			# cave around the virtual environment.
			caveView = vizcave.CaveView(viewpoint)
			_window.originLink = viz.link(originNode, caveView, dstFlag=viz.ABS_GLOBAL, srcFlag=viz.ABS_GLOBAL)
			_window.caveView = caveView
			_window.originNode = originNode
			_window.displayNode = cave
			_window.viewpointNode = viewpoint
			_window.windowList = windowList
			
			rawDisplay[_name] = _window
	
		#VC: init the wrapper (DO NOT EDIT)
		if initFlag&vizconnect.INIT_WRAPPERS:
			vizconnect.addDisplay(rawDisplay[_name], _name, make='Generic', model='Corner Cave Manual Configuration Single Machine')
	
		#VC: set the parent of the node
		if initFlag&vizconnect.INIT_PARENTS:
			vizconnect.getDisplay(_name).setParent(vizconnect.getAvatar('head_and_hand').getAttachmentPoint('head'))

	#VC: set the name of the default
	vizconnect.setDefault('display', 'corner_cave_manual_configuration_single_machine')

	#VC: return values can be modified here
	return None


#################################
# Tracker Code
#################################

def initTrackers(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawTracker = vizconnect.getRawTrackerDict()

	#VC: initialize a new tracker
	_name = '3d_glass_head_tracker'
	if vizconnect.isPendingInit('tracker', _name, initFlag, initList):
		#VC: init the raw object
		if initFlag&vizconnect.INIT_RAW:
			#VC: set some parameters
			pptHostname = '169.254.159.147'
			markerId = 1
			
			#VC: create the raw object
			vrpn7 = viz.add('vrpn7.dle')
			rawTracker[_name] = vrpn7.addTracker('PPT0@'+pptHostname, markerId-1)
	
		#VC: init the wrapper (DO NOT EDIT)
		if initFlag&vizconnect.INIT_WRAPPERS:
			vizconnect.addTracker(rawTracker[_name], _name, make='WorldViz', model='PPT')

	#VC: initialize a new tracker
	_name = 'wand_hand_tracker'
	if vizconnect.isPendingInit('tracker', _name, initFlag, initList):
		#VC: init the raw object
		if initFlag&vizconnect.INIT_RAW:
			#VC: set some parameters
			pptHostname = '169.254.159.147'
			markerId = 3
			
			#VC: create the raw object
			vrpn7 = viz.add('vrpn7.dle')
			rawTracker[_name] = vrpn7.addTracker('PPT0@'+pptHostname, markerId-1)
	
		#VC: init the wrapper (DO NOT EDIT)
		if initFlag&vizconnect.INIT_WRAPPERS:
			vizconnect.addTracker(rawTracker[_name], _name, make='WorldViz', model='PPT')

	#VC: return values can be modified here
	return None


#################################
# Input Code
#################################

def initInputs(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawInput = vizconnect.getRawInputDict()

	#VC: initialize a new input
	_name = 'ppt_wand_input_hand'
	if vizconnect.isPendingInit('input', _name, initFlag, initList):
		#VC: init the raw object
		if initFlag&vizconnect.INIT_RAW:
			#VC: set some parameters
			hostname = '169.254.159.147'
			markerId = 3
			
			#VC: create the raw object
			from vizconnect.util.input import viz_wand
			rawInput[_name] = viz_wand.Wand(hostname, markerId)
	
		#VC: init the wrapper (DO NOT EDIT)
		if initFlag&vizconnect.INIT_WRAPPERS:
			vizconnect.addInput(rawInput[_name], _name, make='WorldViz', model='PPT Wand')

	#VC: initialize a new input
	_name = 'keyboard'
	if vizconnect.isPendingInit('input', _name, initFlag, initList):
		#VC: init the raw object
		if initFlag&vizconnect.INIT_RAW:
			#VC: set some parameters
			index = 0
			
			#VC: create the raw object
			d = viz.add('directinput.dle')
			device = d.getKeyboardDevices()[index]
			rawInput[_name] = d.addKeyboard(device)
	
		#VC: init the wrapper (DO NOT EDIT)
		if initFlag&vizconnect.INIT_WRAPPERS:
			vizconnect.addInput(rawInput[_name], _name, make='Generic', model='Keyboard')

	#VC: return values can be modified here
	return None


#################################
# Event Code
#################################

def initEvents(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawEvent = vizconnect.getRawEventDict()
	
	#VC: return values can be modified here
	return None


#################################
# Transport Code
#################################

def initTransports(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawTransport = vizconnect.getRawTransportDict()

	#VC: initialize a new transport
	_name = 'mytransport_wandmagiccarpet'
	if vizconnect.isPendingInit('transport', _name, initFlag, initList):
		#VC: request that any dependencies be created
		if initFlag&vizconnect.INIT_INDEPENDENT:
			initTrackers(vizconnect.INIT_INDEPENDENT, ['3d_glass_head_tracker'])
	
		#VC: init the raw object
		if initFlag&vizconnect.INIT_RAW:
			#VC: set some parameters
			orientationTracker = vizconnect.getTracker('3d_glass_head_tracker').getNode3d()
			debug = False
			acceleration = 2
			maxSpeed = 2
			rotationAcceleration = 60
			maxRotationSpeed = 65
			autoBreakingDragCoef = 0.1
			dragCoef = 0.0001
			rotationAutoBreakingDragCoef = 0.2
			rotationDragCoef = 0.0001
			usingPhysics = False
			parentedTracker = False
			transportationGroup = None
			
			#VC: create the raw object
			from transportation import wand_magic_carpet
			rawTransport[_name] = wand_magic_carpet.WandMagicCarpet(	orientationTracker=orientationTracker,
																					debug=debug,
																					acceleration=acceleration,
																					maxSpeed=maxSpeed,
																					rotationAcceleration=rotationAcceleration,
																					maxRotationSpeed=maxRotationSpeed,
																					autoBreakingDragCoef=autoBreakingDragCoef,
																					dragCoef=dragCoef,
																					rotationAutoBreakingDragCoef=rotationAutoBreakingDragCoef,
																					rotationDragCoef=rotationDragCoef,
																					usingPhysics=usingPhysics,
																					parentedTracker=parentedTracker,
																					node=transportationGroup)
	
		#VC: init the mappings for the raw object
		if initFlag&vizconnect.INIT_MAPPINGS:
			#VC: per frame mappings
			if initFlag&vizconnect.INIT_MAPPINGS_PER_FRAME:
				#VC: get the raw input dict so we have access to signals
				import vizact
				rawInput = vizconnect.getConfiguration().getRawDict('input')
				#VC: set the update function which checks for input signals
				def update(transport):
					if rawInput['ppt_wand_input_hand'].getJoystickPosition()[1] < -0.05:# make=WorldViz, model=PPT Wand, name=ppt_wand_input_hand, signal=Analog Up
						transport.moveForward(mag=abs(rawInput['ppt_wand_input_hand'].getJoystickPosition()[1]))
					if rawInput['ppt_wand_input_hand'].getJoystickPosition()[1] > 0.05:# make=WorldViz, model=PPT Wand, name=ppt_wand_input_hand, signal=Analog Down
						transport.moveBackward(mag=abs(rawInput['ppt_wand_input_hand'].getJoystickPosition()[1]))
					if rawInput['ppt_wand_input_hand'].getJoystickPosition()[0] < -0.05:# make=WorldViz, model=PPT Wand, name=ppt_wand_input_hand, signal=Analog Left
						transport.moveLeft(mag=abs(rawInput['ppt_wand_input_hand'].getJoystickPosition()[0]))
					if rawInput['ppt_wand_input_hand'].getJoystickPosition()[0] > 0.05:# make=WorldViz, model=PPT Wand, name=ppt_wand_input_hand, signal=Analog Right
						transport.moveRight(mag=abs(rawInput['ppt_wand_input_hand'].getJoystickPosition()[0]))
					if rawInput['ppt_wand_input_hand'].isButtonDown(2):# make=WorldViz, model=PPT Wand, name=ppt_wand_input_hand, signal=Top Right Button
						transport.moveUp(mag=1)
					if rawInput['ppt_wand_input_hand'].isButtonDown(3):# make=WorldViz, model=PPT Wand, name=ppt_wand_input_hand, signal=Bottom Right Button
						transport.moveDown(mag=1)
					if rawInput['ppt_wand_input_hand'].isButtonDown(1):# make=WorldViz, model=PPT Wand, name=ppt_wand_input_hand, signal=Top Left Button
						transport.turnLeft(mag=1)
					if rawInput['ppt_wand_input_hand'].isButtonDown(0):# make=WorldViz, model=PPT Wand, name=ppt_wand_input_hand, signal=Bottom Left Button
						transport.turnRight(mag=1)
				rawTransport[_name].setUpdateFunction(update)
	
		#VC: init the wrapper (DO NOT EDIT)
		if initFlag&vizconnect.INIT_WRAPPERS:
			vizconnect.addTransport(rawTransport[_name], _name, make='Virtual', model='WandMagicCarpet')
	
		#VC: set the parent of the node
		if initFlag&vizconnect.INIT_PARENTS:
			vizconnect.getTransport(_name).setParent(vizconnect.getRoot())
	
		#VC: set the pivot of the node
		if initFlag&vizconnect.INIT_PIVOTS:
			vizconnect.getTransport(_name).setPivot(vizconnect.getDisplay('corner_cave_manual_configuration_single_machine').getNode3d())

	#VC: return values can be modified here
	return None


#################################
# Tool Code
#################################

def initTools(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawTool = vizconnect.getRawToolDict()

	#VC: initialize a new tool
	_name = 'grabber'
	if vizconnect.isPendingInit('tool', _name, initFlag, initList):
		#VC: init which needs to happen before viz.go
		if initFlag&vizconnect.INIT_PREVIZGO:
			viz.setOption('viz.display.stencil',1)
	
		#VC: init the raw object
		if initFlag&vizconnect.INIT_RAW:
			#VC: initialization code needed by the parameters
			import tools
			from tools import grabber
			from tools import highlighter
			
			#VC: set some parameters
			usingPhysics = False
			highlightMode = tools.highlighter.MODE_OUTLINE
			placementMode = tools.placer.MODE_MID_AIR
			
			#VC: create the raw object
			rawTool[_name] = grabber.Grabber(usingPhysics=usingPhysics, usingSprings=usingPhysics, highlightMode=highlightMode, placementMode=placementMode, updatePriority=vizconnect.PRIORITY_ANIMATOR+3)
	
		#VC: init the mappings for the raw object
		if initFlag&vizconnect.INIT_MAPPINGS:
			#VC: per frame mappings
			if initFlag&vizconnect.INIT_MAPPINGS_PER_FRAME:
				#VC: get the raw input dict so we have access to signals
				import vizact
				rawInput = vizconnect.getConfiguration().getRawDict('input')
				#VC: set the update function which checks for input signals
				def update(tool):
					if rawInput['ppt_wand_input_hand'].isButtonDown(5):# make=WorldViz, model=PPT Wand, name=ppt_wand_input_hand, signal=Trigger Button
						tool.grabAndHold()
					if rawInput['ppt_wand_input_hand'].isButtonDown(1):# make=WorldViz, model=PPT Wand, name=ppt_wand_input_hand, signal=Top Left Button
						tool.grab()
					if rawInput['ppt_wand_input_hand'].isButtonDown(2):# make=WorldViz, model=PPT Wand, name=ppt_wand_input_hand, signal=Top Right Button
						tool.release()
				rawTool[_name].setUpdateFunction(update)
	
		#VC: init the wrapper (DO NOT EDIT)
		if initFlag&vizconnect.INIT_WRAPPERS:
			vizconnect.addTool(rawTool[_name], _name, make='Virtual', model='Grabber')
	
		#VC: set the parent of the node
		if initFlag&vizconnect.INIT_PARENTS:
			vizconnect.getTool(_name).setParent(vizconnect.getAvatar('head_and_hand').getAttachmentPoint('r_hand'))

	#VC: set the name of the default
	vizconnect.setDefault('tool', 'grabber')

	#VC: return values can be modified here
	return None


#################################
# Avatar Code
#################################

def initAvatars(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawAvatar = vizconnect.getRawAvatarDict()

	#VC: initialize a new avatar
	_name = 'head_and_hand'
	if vizconnect.isPendingInit('avatar', _name, initFlag, initList):
		#VC: init the raw object
		if initFlag&vizconnect.INIT_RAW:
			#VC: set some parameters
			rightHandFilename = 'glove.cfg'
			leftHandFilename = ''
			
			#VC: create the raw object
			# base avatar
			avatar = viz.addGroup()
			avatar._bodyPartDict = {}
			avatar._handModelDict = {}
			# head
			head = viz.addGroup()
			head.setParent(avatar)
			avatar._bodyPartDict[vizconnect.AVATAR_HEAD] = head
			# left hand
			if leftHandFilename:
				leftHand = avatar.add(leftHandFilename)
				avatar.leftHandFilename = leftHandFilename
			else:
				leftHand = viz.addGroup()
				avatar.leftHandFilename = None
			leftHand.setParent(avatar)
			avatar._bodyPartDict[vizconnect.AVATAR_L_HAND] = leftHand
			# right hand
			if rightHandFilename:
				rightHand = avatar.add(rightHandFilename)
				avatar.rightHandFilename = rightHandFilename
			else:
				rightHand = viz.addGroup()
				avatar.rightHandFilename = None
			rightHand.setParent(avatar)
			avatar._bodyPartDict[vizconnect.AVATAR_R_HAND] = rightHand
			# done
			rawAvatar[_name] = avatar
	
		#VC: init the wrapper (DO NOT EDIT)
		if initFlag&vizconnect.INIT_WRAPPERS:
			vizconnect.addAvatar(rawAvatar[_name], _name, make='Generic', model='Head and Hand')
	
		#VC: init the gestures
		if initFlag&vizconnect.INIT_GESTURES:
			#VC: need to get the raw input dict so we have access to signals
			import vizact
			rawInput = vizconnect.getConfiguration().getRawDict('input')
			
			#VC: gestures for the avatar's r_hand
			import hand
			# remove the old hand
			rightHand = rawAvatar[_name]._bodyPartDict[vizconnect.AVATAR_R_HAND]
			if rightHand:
				rightHand.remove()
			# add a new hand
			def initHand():
				sensor = hand.InputSensor()
				rawAvatar[_name].handSensor = sensor
				sensor.createHandRenderer = lambda *args,**kw: hand._InputDeviceRenderer(*args,**kw)
				def appliedGetData():
					#VC: set the mappings for the gestures
					if rawInput['ppt_wand_input_hand'].isButtonDown(5):# make=WorldViz, model=PPT Wand, name=ppt_wand_input_hand, signal=Trigger Button
						return (hand.GESTURE_FIST, False, False)# GESTURE_FIST
					#VC: end gesture mappings
					return (hand.GESTURE_FLAT_HAND,False,False)
				sensor.getData = appliedGetData
				file=None
				if hasattr(rawAvatar[_name], "rightHandFilename"):
					file = rawAvatar[_name].rightHandFilename
				return hand.HandModel(left=False, type=hand.GLOVE_5DT, file=file, sensor=sensor)
			rightHand = initHand()
			rightHand.setParent(rawAvatar[_name])
			rawAvatar[_name]._bodyPartDict[vizconnect.AVATAR_R_HAND] = rightHand
			rawAvatar[_name]._handModelDict[vizconnect.AVATAR_R_HAND] = rightHand
			
			#VC: gestures may change the raw avatar, so refresh the raw in the wrapper
			vizconnect.getAvatar(_name).setRaw(rawAvatar[_name])
	
		#VC: init the animator
		if initFlag&vizconnect.INIT_ANIMATOR:
			# need to get the raw tracker dict for animating the avatars
			from vizconnect.util.avatar import animator
			from vizconnect.util.avatar import skeleton
			
			# get the skeleton from the avatar
			_skeleton = skeleton.Disembodied(rawAvatar[_name])
			
			#VC: set which trackers animate which body part
			# format is: bone: (tracker, parent, degrees of freedom used)
			_trackerAssignmentDict = {
				vizconnect.AVATAR_HEAD:(vizconnect.getTracker('3d_glass_head_tracker').getNode3d(), None, vizconnect.DOF_6DOF),
				vizconnect.AVATAR_R_HAND:(vizconnect.getTracker('wand_hand_tracker').getNode3d(), None, vizconnect.DOF_6DOF),
			}
			
			#VC: create the raw object
			_rawAnimator = animator.Disembodied(rawAvatar[_name], _skeleton, _trackerAssignmentDict)
			
			#VC: set animator in wrapper (DO NOT EDIT)
			vizconnect.getAvatar(_name).setAnimator(_rawAnimator, make='Virtual', model='Disembodied')
	
		#VC: set the parent of the node
		if initFlag&vizconnect.INIT_PARENTS:
			vizconnect.getAvatar(_name).setParent(vizconnect.getGroup('corner_cave_manual_configuration_single_machine'))

	#VC: return values can be modified here
	return None


#################################
# Application Settings
#################################

def initSettings():
	#VC: apply general application settings
	viz.mouse.setTrap(False)
	viz.mouse.setVisible(viz.MOUSE_AUTO_HIDE)
	vizconnect.setMouseTrapToggleKey('')
	
	#VC: return values can be modified here
	return None


#################################
# Post-initialization Code
#################################

def postInit():
	"""Add any code here which should be called after all of the initialization of this configuration is complete.
	Returned values can be obtained by calling getPostInitResult for this file's vizconnect.Configuration instance."""
	return None


#################################
# Stand alone configuration
#################################

def initInterface():
	#VC: start the interface
	vizconnect.interface.go(__file__,
							live=True,
							openBrowserWindow=True,
							startingInterface=vizconnect.interface.INTERFACE_STARTUP)

	#VC: return values can be modified here
	return None


###############################################

if __name__ == "__main__":
	initInterface()
	viz.add('piazza.osgb')
	viz.add('piazza_animations.osgb')


