﻿import viz
import vizconfig
import vizdragdrop
import vizshape
import vizact

viz.go(viz.FULLSCREEN | viz.QUAD_BUFFER) #to enable quad buffer, must be in the start
#viz.MainWindow.stereo(viz.ANAGLYPHIC)

#viz.MainWindow.ipd(.06)
#viz.MainWindow.screenDistance(1)
#viz.MainWindow.fov(40)
#viz.MainWindow.fusionDistance(2.5)

#Create a configurable object for stereo settings
bc= vizconfig.BasicConfigurable('stereo')
bc.addChoiceRadioItem('Stereo Format',[('Quad buffer',viz.QUAD_BUFFER), \
										('Anaglyphic',viz.ANAGLYPHIC), \
										('Side by Side TV',viz.STEREO_3DTV_SIDE_BY_SIDE), \
										('Top Bottom TV',viz.STEREO_3DTV_TOP_AND_BOTTOM),\
										('Horizontal Stereo for 2 channels',viz.STEREO_HORZ)],\
										viz.MainWindow.stereo,viz.MainWindow.getStereo)
bc.addFloatRangeItem('Inter-pulilary Distance',[-.5,.5],fset=viz.MainWindow.ipd,fget=viz.MainWindow.getIPD)
bc.addFloatRangeItem('Screen Distance',[0,5],fset=viz.MainWindow.screenDistance,fget=viz.MainWindow.getScreenDistance)
bc.addFloatRangeItem('Field of View Vertical',[10,150],fset=viz.MainWindow.fov,fget=viz.MainWindow.getVerticalFOV)
bc.addFloatRangeItem('Fusion Distance',[.2,10],fset=viz.MainWindow.fusionDistance,fget=viz.MainWindow.getFusionDistance)
vizconfig.register(bc)
vizconfig.getConfigWindow().setWindowVisible(True)

gallery = viz.add('gallery.osgb')

f = viz.add('vcc_female.cfg', pos=[0, 0, 2])
f.state(5)






vrpn = viz.add('vrpn7.dle')
tracker0 = vrpn.addTracker('PPT0@WorldViz-PC',0)
tracker1 = vrpn.addTracker('PPT0@WorldViz-PC',1)

# Add PPT extension 
ppt = viz.add('ppt.dle')

# Add wand
wand = ppt.addWand(9)


def onTrigger():
    print 'Trigger pressed'
    
vizact.onsensordown(wand, ppt.BUTTON_TRIGGER, onTrigger)


def onRightButton():
    print 'Right pressed'
    
vizact.onsensordown(wand, ppt.BUTTON_RIGHT, onRightButton)


def onLeftButton():
    print 'Left pressed'
    
vizact.onsensordown(wand, ppt.BUTTON_LEFT, onLeftButton)


def onUpButton():
    print 'Up pressed'
    
vizact.onsensordown(wand, ppt.BUTTON_UP, onUpButton)



view = viz.MainView
viz.link(tracker0, view)
viz.link(tracker1, view)
