﻿

"""
Xenium Digital Engine Virtual Reality Training Demo.
This demo demonstrates the use of VR for Engine de-assembling and re-assembling of engine parts.
Step1:First de-assemble each parts with your virtual hand and see to each part of the engine in detail.
Step2:Secondly re-assemble each engine parts to make it to full engine.
"""


import viz
import vizact
import vizconnect
import vizshape
import vizproximity
import view_collision
import vizinfo
import vizconfig

p=vizinfo.InfoPanel(align=viz.ALIGN_LEFT_TOP)

viz.setMultiSample(4)

#Getting the 3D stereo for the interpulliary distance
viz.ipd(0.01)
vizconnect.go('vizconnect_config.py')

'''

viz.ipd(0.01)
viz.fusionDistance(2.00)
viz.fov(25.17)
viz.screenDistance(1.00)
'''



#viz.MainView.collision(viz.ON)
viz.phys.enable()

#Displaying GUi for 



#pigeon = viz.addAvatar('pigeon.cfg',scale=[200]*3)
engineInfo=viz.addChild('engineInfo.OSGB',scale=[200]*7)
engineAnim=engineInfo.getChild('Jet_Engine_Model');

engineAnim.setAnimationState(-1)
engineInfo.addAction(vizact.spin(0,1,0,45,viz.FOREVER))
engineInfo.enable(viz.DEPTH_TEST,op=viz.OP_ROOT)

#Add the pigeon to the panel
panel = vizinfo.InfoPanel('Xenium Digital Engine Virtual Reality Training Demo',align=viz.ALIGN_CENTER,fontSize=22,icon=False)
panel.addItem(engineInfo,align=viz.ALIGN_CENTER)

count=0
def InfoPanelToogle():
    panel.visible(viz.TOGGLE)
    if count > 0:
         panel.visible(viz.OFF)
vizact.ontimer(1,InfoPanelToogle)


def InfoPanelPermanentOff(e):
    global count
    count+=1
    print count
    panel.visible(viz.OFF)
     
viz.callback(viz.SENSOR_DOWN_EVENT,InfoPanelPermanentOff)

def InfoPanelToogleInfo():
    p.visible(viz.TOGGLE)
vizact.ontimer(1,InfoPanelToogleInfo)


# oriMode sets what the viewpoint is resetting to. For example...
# vizconnect.VIEWPOINT_MATCH_DISPLAY
# matches orientation of the display to the orientation of the viewpoint
# 
# vizconnect.VIEWPOINT_MATCH_FEET
# matches orientation of the feet to the orientation of the viewpoint
# 
# vizconnect.VIEWPOINT_MATCH_BASE
# matches orientation of the base object (transport, avatar, tracker) to the orientation of the viewpoint
#
# Similar for posMode
oriMode = vizconnect.VIEWPOINT_MATCH_DISPLAY
posMode = vizconnect.VIEWPOINT_MATCH_FEET

# Add a viewpoint.
vp = vizconnect.addViewpoint(	pos=[0, 0, 0],
								euler=[90, 0, 0],
								posMode=posMode,
								oriMode=oriMode,
								constant=False,
								)
# Displays are added to viewpoints, the viewpoint will traverse the scenegraph to
# determine if the display is attached to an avatar, tracker, etc in order to
# perform the requested resets.
vp.add(vizconnect.getDisplay())

# Call reset viewpoints, which forces the display into the viewpoint position.
# This function can be called as often as desired, it is currently also mapped
# onto the insert button.
vizconnect.resetViewpoints()
# add a reset key so when r is pressed the user is moved back back to the viewpoint
vizact.onkeydown('r', vizconnect.resetViewpoints)

#-----------------Reset viewpoint end

#storing positions of engine parts in dictionary

positionDict=[]
backOuterPos=[0.34,1.01,0.76]
positionDict.append(backOuterPos)
engineGrpPos=[0.56,0.82,-0.09]
positionDict.append(engineGrpPos)
backPartPos=[0.42,0.81,0.48]
positionDict.append(backPartPos)

print positionDict[0],positionDict[1],positionDict[2]



# Add a background environment
dojo=viz.addChild('dojo.osgb')
#dojo=viz.addChild('engine_Area.osgb')
engine=viz.addChild('Without Animation Engine.OSGB');

engine.setAnimationState(-1)
dojo.collideMesh()
dojo.hint(viz.OPTIMIZE_INTERSECT_HINT)
engine.collideMesh()
engine.hint(viz.OPTIMIZE_INTERSECT_HINT)


mainBody=engine.getChild('main_body');
backOuter=engine.getChild('back_outer_part');
engineGrp=engine.getChild('Engine_grp');
backPart=engine.getChild('back_part_grp');

#stopping the animation of engine grp

en=engineGrp.getChild('engine_outer')
en.setAnimationState

#getting subparts of engine_Outer_parts
backOuterFirst=engine.getChild('outer_face_01_grp');
backOuterSecond=engine.getChild('outer_face_02_grp');
backOuterThird=engine.getChild('outer_face_03_grp');



#applying avatar collision
ac = view_collision.AvatarCollision(collideTrackers=True)
ac.setCollideList([vizconnect.AVATAR_HEAD])
ac.setTransport(vizconnect.getTransport().getNode3d())


#Printing the eulers
print 'The eulers'
print engine.getTransform('main_body').getEuler()
print engine.getTransform('back_outer_part').getEuler()
print engine.getTransform('Engine_grp').getEuler()
print engine.getTransform('back_part_grp').getEuler()


#printing the posiitons
print 'The positions'
print engine.getTransform('main_body').getPosition()
print engine.getTransform('back_outer_part').getPosition()
print engine.getTransform('Engine_grp').getPosition()
print engine.getTransform('back_part_grp').getPosition()

#printing the transforms
print 'The transforms'
print engine.getTransform('main_body')
print engine.getTransform('back_outer_part')
print engine.getTransform('Engine_grp')
print engine.getTransform('back_part_grp')



#adding models of the engine to be grabbed
#shapes = [mainBody,backOuter,engineGrp,backPart]
#shapes = [backPart,backOuter]
shapes = [engineGrp,backPart,backOuter]
#shapes = [engnn,backPart,backOuter]
# Code to get the grabber tool by name and supply the list of items which can be grabbed 
grabber = vizconnect.getRawTool('grabber')
grabber.setItems(shapes)


#-----------------Promity area code-----------#

manager=vizproximity.Manager()
manager.setDebug(viz.ON)

#Add grabber tool  as proximity target

target = vizproximity.Target(grabber)
manager.addTarget(target)

'''
target = vizproximity.Target(engineGrp)
manager.addTarget(target)


target1 = vizproximity.Target(backOuter)
manager.addTarget(target)

target2 = vizproximity.Target(backPart)
manager.addTarget(target)

'''

#adding sensor for mainbody
mainBodysensor = vizproximity.Sensor(vizproximity.Box([10,35,10],center=[0,-6,4]),mainBody)
manager.addSensor(mainBodysensor)
'''
#adding sensor for backouter
backOuterSensor = vizproximity.Sensor(vizproximity.Box([5,5,5],center=[0,-15,4]),backOuter)
manager.addSensor(backOuterSensor)


#adding sensor for engineGrpsensor
engineGrpsensor = vizproximity.Sensor(vizproximity.Box([4,4,4],center=[-10,-3,4]),engineGrp)
manager.addSensor(engineGrpsensor)

#adding sensor for backpartsensor
backPartSensor = vizproximity.Sensor(vizproximity.Box([10,5,5],center=[0,-17,4]),backPart)
manager.addSensor(backPartSensor)
'''
#checking for proximity range

#Reassemble the parts when comes in contacts with different proximitiesOCEhell


def EnterProximity(e):
    if e.sensor==mainBodysensor:
       print 'mainbody sensor'
       
    if e.sensor==mainBodysensor:
        print 'backouter sensor'
        backOuter.setPosition([0.72,0.71,-0.41],viz.ABS_GLOBAL)
        backOuter.setEuler(engine.getTransform('back_outer_part').getEuler())
        
    if e.sensor==mainBodysensor:
         print 'enginegrp sensor'
         engineGrp.setPosition([0.72,0.71,-0.41],viz.ABS_GLOBAL)
         engineGrp.setEuler(engine.getTransform('Engine_grp').getEuler())
        
    if e.sensor==mainBodysensor:
         print 'backpart  sensor'
         backPart.setPosition([0.72,0.71,-0.41],viz.ABS_GLOBAL)
         backPart.setEuler(engine.getTransform('back_part_grp').getEuler())
       
      

#Change state of avatar to idle when the user moves away
def ExitProximity(e):
    print 'Events'

#-----Registering sensors on sensors are--------#
manager.onEnter(None,EnterProximity)
#manager.onExit(manBodysensor,ExitProximity)




#--------------Grabbing Python Logic---------------#


def onGrab(e):
    if e.grabbed == backOuter:
        backOuter.grabbed=True
        
    if e.grabbed == engineGrp:
       engineGrp.grabbed=True

    if e.grabbed == backPart:
       backPart.grabbed=True


def onRelease(e):
    #Reassembling logic for the engine parts
    if e.released==backOuter:
       backOuter.grabbed=False
       
    if e.released==engineGrp:
       engineGrp.grabbed=False

    if e.released==backPart:
       backPart.grabbed=False
       
       

        

from tools import grabber
viz.callback(grabber.GRAB_EVENT, onGrab)
viz.callback(grabber.RELEASE_EVENT, onRelease)

