import viz
viz.go()

file = open('ReactionTimeXID.txt','a')

import viztask

#Connect to xid device
import vizxid
vizxid.open(18) #Default: port=1 , baudRate=115200

def TestReactionTime():
	
	#Add instruction label
	label = viz.addText('Press the spacebar to start the experiment\nWhen the red square turns green, press button 3 on the cedrus pad',viz.ORTHO)
	label.alignment(viz.TEXT_CENTER_CENTER)
	label.fontSize(24)
	viz.link(viz.CenterCenter,label)
	
	#Start expirement when spacebar is pressed
	yield viztask.waitKeyDown(' ')

	#Remove the label
	label.remove()
	
	#Add quad to screen
	quad = viz.addTexQuad(viz.SCREEN)
	quad.setPosition(0.5,0.5)
	quad.setScale(4,4,4)
	
	#Data for getting values from wait conditions
	d = viz.Data()
	
	while True:
		
		#Set quad to red color
		quad.color(viz.RED)
	
		#Wait random amount of time
		yield viztask.waitTime( vizmat.GetRandom(1.5,2.5) )
		
		#Set quad color to green
		quad.color(viz.GREEN)
		
		#Wait for next frame to be drawn to screen
		yield vizxid.waitDraw()
		
		#Wait for button 3 on XID to be pressed
		yield vizxid.waitButtonDown(3,d)
		
		#Calculate reaction time
		reactionTime = d.time
		print 'Reaction time:',reactionTime
		file.write(str(reactionTime)+'\n')
		
	#Remove the quad
	quad.remove()
	
viztask.schedule( TestReactionTime() )