import viz
viz.go()

viz.clearcolor(viz.SKYBLUE)

SIZE = 50

#import kgarr module
import kgarr

#Create a height field that is SIZE x SIZE
hf = kgarr.HeightField(SIZE,SIZE)

#Set height of column 2, row 0 to 1
hf.setHeight(2,0,1)

#Set spacing between columns and rows to 1
hf.setSpacing(1,1)

#Generate 2D array of random height and color values
height = [ [vizmat.GetRandom(0,0.5) for x in range(SIZE)] for y in range(SIZE) ]
color = [ [ [vizmat.GetRandom(0,1.0),vizmat.GetRandom(0,1.0),vizmat.GetRandom(0,1.0)] for x in range(SIZE)] for y in range(SIZE) ]

#Apply array to entire height field
hf.setHeight(height)

#Apply color array to height field
hf.setColor(color)

#Disable lighting
hf.disable(viz.LIGHTING)

#Create wire frame version of height field
wireHF = kgarr.HeightField(SIZE,SIZE)
wireHF.setSpacing(1,1)
wireHF.setHeight(height)
wireHF.color(viz.BLACK)
wireHF.renderWire() #default render mode is hf.renderPolygon(), can also render as points using hf.renderPoint()
wireHF.disable(viz.LIGHTING)
wireHF.zoffset(-1)