import viz

class HeightField(viz.VizNode):
	def __init__(self,width,height):
		self.__height = viz.add('HeightField.dlc',0,'',width,height)
		viz.VizNode.__init__(self,self.__height.id)
		
	def setSpacing(self,x,y):
		self.__height.command(1,'',x,y)
		
	def setHeight(self,x,y=0,z=0):
		if viz._islist(x):
			for r in range(len(x)):
				for c in range(len(x[r])):
					self.setHeight(c,r,x[c][r])
		else:
			self.__height.command(0,'',x,y,z)

	def renderPolygon(self):
		self.__height.command(2)
		
	def renderWire(self):
		self.__height.command(3)
		
	def renderPoint(self):
		self.__height.command(4)
		
	def color(self,r,g=0,b=0):
		if viz._islist(r):
			self.__height.command(5,'',r[0],r[1],r[2])
		else:
			self.__height.command(5,'',r,g,b)
