﻿import viz
viz.go()

viz.add('tut_ground.wrl')

#Create models with tooltip text
ball1 = viz.add('ball.wrl',pos=(-2,1,5))
ball1.tooltip1 = 'Ball 1'

ball2 = viz.add('ball.wrl',pos=(0,1,5))
ball2.tooltip2 = 'Ball 2'

ball3 = viz.add('ball.wrl',pos=(2,1,5))
ball3.tooltip3 = 'Ball 3'

#Create a tool tip object
import viztip
tip = viztip.ToolTip()

tip.message('Toggle the tooltip with the spacebar')
tip.translate(275,50)

vizact.onkeydown(' ',tip.visible,viz.TOGGLE)

import vizact 
spin = vizact.spin(0,1,0,45)

def spinBall():
    if tip.getNode() == ball1:
        ball1.addAction(spin)

vizact.onkeydown('s',spinBall)

#Create different tooltips per ball (Takis)
tip1 = viztip.ToolTip()
tip2 = viztip.ToolTip()
tip3 = viztip.ToolTip()

tip1.setTextName('tooltip1')
tip2.setTextName('tooltip2')
tip3.setTextName('tooltip3')

vizact.onkeydown('1',tip1.visible,viz.TOGGLE)
vizact.onkeydown('2',tip2.visible,viz.TOGGLE)
vizact.onkeydown('3',tip3.visible,viz.TOGGLE)

tip1.translate(ball1.getPosition()[0], ball1.getPosition()[1])
tip1.message('Click this ball')

import vizdlg
import vizshape

class CustomTooltip:
	def __init__(self):
		self._window = viz.MainWindow
		self.tooltips = []
		self.addShape()
	
	def addShape(self):
		self.s = vizshape.addCylinder(height = 1, radius = 0.2, topRadius = None, bottomRadius = 0.18,   
					axis = vizshape.AXIS_Z, slices = 20, bottom = True, top = True)
		self.s.setParent(parent=viz.SCREEN, scene=viz.MainScene)
		self.s.setPosition([.5,.5,0])
		
	def addTooltip(self, pos):
		self.tipTab = vizdlg.TabPanel(window=self._window,
				#layout=vizdlg.LAYOUT_VERT_LEFT,
				align=vizdlg.ALIGN_LEFT_TOP,
				skin=None,
				margin=None,
				spacing=0,
				padding=0,
				fontSize=12,
				theme=None,
				drawOrder=0,
				background=True,
				border=False)
		self.tipPanel = vizdlg.Panel(window=self._window,
				#layout=vizdlg.LAYOUT_VERT_LEFT,
				align=vizdlg.ALIGN_LEFT_TOP,
				skin=None,
				margin=None,
				spacing=5,
				padding=0,
				fontSize=12,
				theme=None,
				drawOrder=0,
				background=False,
				border=False)
		self.tooltips.append(self.tipTab)
		self.tipTab.addPanel('Test',self.tipPanel,viz.ALIGN_LEFT_TOP)
		votes = viz.addText('Votes: 10')
		self.tipPanel.addItem(votes)
		self.tipLink = viz.link(self.s, self.tipTab, mask = viz.LINK_POS, offset=(0,0,0))
		
t=CustomTooltip()
t.addTooltip([])
t.tipLink.setOffset([100,200,0])