"""
This module was generated by Vizconnect.
Version: 1.0
Generated on: 2014-03-17 10:44:55.466000
"""

import viz
import vizconnect

#################################
# Parent configuration, if any
#################################

def getParentConfiguration():
	#VC: set the parent configuration
	_parent = ''
	
	#VC: return the parent configuration
	return _parent


#################################
# Pre viz.go() Code
#################################

def preVizGo():
	return True


#################################
# Pre-initialization Code
#################################

def preInit():
	"""Add any code here which should be called after viz.go but before any initializations happen.
	Returned values can be obtained by calling getPreInitResult for this file's vizconnect.Configuration instance."""
	return None


#################################
# Group Code
#################################

def initGroups(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawGroup = vizconnect.getRawGroupDict()

	#VC: initialize a new group
	_name = 'zspace'
	if vizconnect.isPendingInit('group', _name, initFlag, initList):
		#VC: init the raw object
		if initFlag&vizconnect.INIT_RAW:
			#VC: create the raw object
			rawGroup[_name] = viz.addGroup()
	
		#VC: init the wrapper (DO NOT EDIT)
		if initFlag&vizconnect.INIT_WRAPPERS:
			vizconnect.addGroup(rawGroup[_name], _name, make='Virtual', model='Origin')

	#VC: return values can be modified here
	return None


#################################
# Display Code
#################################

def initDisplays(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawDisplay = vizconnect.getRawDisplayDict()

	#VC: initialize a new display
	_name = 'zspace'
	if vizconnect.isPendingInit('display', _name, initFlag, initList):
		#VC: init which needs to happen before viz.go
		if initFlag&vizconnect.INIT_PREVIZGO:
			viz.setOption('viz.stereo', viz.QUAD_BUFFER)
	
		#VC: init the raw object
		if initFlag&vizconnect.INIT_RAW:
			#VC: set the window for the display
			_window = viz.MainWindow
			
			#VC: set some parameters
			scale = 200
			stereSwapKey = ''
			autoDetectMonitorIndex = True
			clientIndex = 0
			
			#VC: create the raw object
			import zspace
			
			# get an origin node
			originName = _name
			initGroups(vizconnect.INIT_INDEPENDENT, [originName])# ensure it's been created
			originNode = vizconnect.getGroup(originName).getNode3d()
			
			# Create a cave object
			import vizcave
			cave = vizcave.Cave(stereo=viz.QUAD_BUFFER)
			
			cave.addWall(zspace.addWall(), mask=2**clientIndex, window=_window)
			
			with viz.cluster.MaskedContext(2**clientIndex):
				# set the fullscreen monitor and fullscreen if selected
				if autoDetectMonitorIndex:
					viz.window.setFullscreenMonitor(zspace.getMonitorNumber())
				viz.window.setFullscreen(True)
			
			_window.setSize([1, 1])
			
			# We need to pass an object which will be used to update the projection
			# or the display to the view's position, typically this would be the
			# node attached to an avatar's head tracker. 
			viewpoint = viz.addGroup()
			cave.setTracker(viewpoint)
			
			# Create a CaveView object for manipulating the entire cave environment.
			# The caveView is a node that can be adjusted to move the entire 
			# cave around the virtual environment.
			caveView = vizcave.CaveView(viewpoint, view=_window.getView())
			
			_window.originLink = viz.link(originNode, caveView, dstFlag=viz.ABS_GLOBAL, srcFlag=viz.ABS_GLOBAL)
			_window.caveView = caveView
			_window.originNode = originNode
			_window.displayNode = cave
			_window.viewpointNode = viewpoint
			
			cave.setTrackerScale(scale)
			caveView.setTrackerScale(scale)
			
			rawDisplay[_name] = _window
	
		#VC: init the wrapper (DO NOT EDIT)
		if initFlag&vizconnect.INIT_WRAPPERS:
			vizconnect.addDisplay(rawDisplay[_name], _name, make='zSpace', model='zSpace')
	
		#VC: set the parent of the node
		if initFlag&vizconnect.INIT_PARENTS:
			vizconnect.getDisplay(_name).setParent(vizconnect.getAvatar('head_and_hand').getAttachmentPoint('head'))

	#VC: return values can be modified here
	return None


#################################
# Tracker Code
#################################

def initTrackers(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawTracker = vizconnect.getRawTrackerDict()

	#VC: initialize a new tracker
	_name = 'zspace_eyes'
	if vizconnect.isPendingInit('tracker', _name, initFlag, initList):
		#VC: init the raw object
		if initFlag&vizconnect.INIT_RAW:
			#VC: create the raw object
			import zspace
			rawTracker[_name] = zspace.getHeadTracker()
	
		#VC: init the wrapper (DO NOT EDIT)
		if initFlag&vizconnect.INIT_WRAPPERS:
			vizconnect.addTracker(rawTracker[_name], _name, make='zSpace', model='zSpace Eyes')
	
		#VC: set the parent of the node
		if initFlag&vizconnect.INIT_PARENTS:
			vizconnect.getTracker(_name).setParent(vizconnect.getGroup('zspace'))

	#VC: initialize a new tracker
	_name = 'zspace_wand'
	if vizconnect.isPendingInit('tracker', _name, initFlag, initList):
		#VC: init the raw object
		if initFlag&vizconnect.INIT_RAW:
			#VC: create the raw object
			import zspace
			rawTracker[_name] = zspace.getWandTracker()
	
		#VC: init the wrapper (DO NOT EDIT)
		if initFlag&vizconnect.INIT_WRAPPERS:
			vizconnect.addTracker(rawTracker[_name], _name, make='zSpace', model='zSpace Wand')
	
		#VC: init the offsets
		if initFlag&vizconnect.INIT_OFFSETS:
			_link = vizconnect.getTracker(_name).getLink()
			#VC: clear link offsets
			_link.reset(viz.RESET_OPERATORS)
			
			#VC: apply offsets
			_link.postScale([200, 200, 200])
	
		#VC: set the parent of the node
		if initFlag&vizconnect.INIT_PARENTS:
			vizconnect.getTracker(_name).setParent(vizconnect.getGroup('zspace'))

	#VC: return values can be modified here
	return None


#################################
# Input Code
#################################

def initInputs(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawInput = vizconnect.getRawInputDict()

	#VC: initialize a new input
	_name = 'wand'
	if vizconnect.isPendingInit('input', _name, initFlag, initList):
		#VC: init the raw object
		if initFlag&vizconnect.INIT_RAW:
			#VC: create the raw object
			import zspace
			rawInput[_name] = zspace.getWandTracker()
	
		#VC: init the wrapper (DO NOT EDIT)
		if initFlag&vizconnect.INIT_WRAPPERS:
			vizconnect.addInput(rawInput[_name], _name, make='zSpace', model='Wand')

	#VC: return values can be modified here
	return None


#################################
# Event Code
#################################

def initEvents(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawEvent = vizconnect.getRawEventDict()

	#VC: return values can be modified here
	return None


#################################
# Transport Code
#################################

def initTransports(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawTransport = vizconnect.getRawTransportDict()

	#VC: return values can be modified here
	return None


#################################
# Tool Code
#################################

def initTools(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawTool = vizconnect.getRawToolDict()

	#VC: return values can be modified here
	return None


#################################
# Avatar Code
#################################

def initAvatars(initFlag=vizconnect.INIT_INDEPENDENT, initList=None):
	#VC: place any general initialization code here
	rawAvatar = vizconnect.getRawAvatarDict()

	#VC: initialize a new avatar
	_name = 'head_and_hand'
	if vizconnect.isPendingInit('avatar', _name, initFlag, initList):
		#VC: init the raw object
		if initFlag&vizconnect.INIT_RAW:
			#VC: set some parameters
			rightHandFilename = 'glove.cfg'
			leftHandFilename = ''
			
			#VC: create the raw object
			# base avatar
			avatar = viz.addGroup()
			avatar._bodyPartDict = {}
			avatar._handModelDict = {}
			# head
			head = viz.addGroup()
			head.setParent(avatar)
			avatar._bodyPartDict[vizconnect.AVATAR_HEAD] = head
			# left hand
			if leftHandFilename:
				leftHand = avatar.add(leftHandFilename)
				avatar.leftHandFilename = leftHandFilename
			else:
				leftHand = viz.addGroup()
				avatar.leftHandFilename = None
			leftHand.setParent(avatar)
			avatar._bodyPartDict[vizconnect.AVATAR_L_HAND] = leftHand
			# right hand
			if rightHandFilename:
				rightHand = avatar.add(rightHandFilename)
				avatar.rightHandFilename = rightHandFilename
			else:
				rightHand = viz.addGroup()
				avatar.rightHandFilename = None
			rightHand.setParent(avatar)
			avatar._bodyPartDict[vizconnect.AVATAR_R_HAND] = rightHand
			# done
			rawAvatar[_name] = avatar
	
		#VC: init the wrapper (DO NOT EDIT)
		if initFlag&vizconnect.INIT_WRAPPERS:
			vizconnect.addAvatar(rawAvatar[_name], _name, make='Generic', model='Head and Hand')
	
		#VC: init the gestures
		if initFlag&vizconnect.INIT_GESTURES:
			#VC: need to get the raw input dict so we have access to signals
			import vizact
			rawInput = vizconnect.getConfiguration().getRawDict('input')
			
			#VC: gestures for the avatar's r_hand
			import hand
			# remove the old hand
			rightHand = rawAvatar[_name]._bodyPartDict[vizconnect.AVATAR_R_HAND]
			if rightHand:
				rightHand.remove()
			# add a new hand
			def initHand():
				sensor = hand.InputSensor()
				rawAvatar[_name].handSensor = sensor
				sensor.createHandRenderer = lambda *args,**kw: hand._InputDeviceRenderer(*args,**kw)
				def appliedGetData():
					#VC: set the mappings for the gestures
					if rawInput['wand'].isButtonDown(0):# make=zSpace, model=Wand, name=wand, signal=Front Button
						return (hand.GESTURE_FIST, False, False)# GESTURE_FIST
					#VC: end gesture mappings
					return (hand.GESTURE_FLAT_HAND,False,False)
				sensor.getData = appliedGetData
				file=None
				if hasattr(rawAvatar[_name], "rightHandFilename"):
					file = rawAvatar[_name].rightHandFilename
				return hand.HandModel(left=False, type=hand.GLOVE_5DT, file=file, sensor=sensor)
			rightHand = initHand()
			rightHand.setParent(rawAvatar[_name])
			rawAvatar[_name]._bodyPartDict[vizconnect.AVATAR_R_HAND] = rightHand
			rawAvatar[_name]._handModelDict[vizconnect.AVATAR_R_HAND] = rightHand
			
			#VC: gestures may change the raw avatar, so refresh the raw in the wrapper
			vizconnect.getAvatar(_name).setRaw(rawAvatar[_name])
	
		#VC: init the animator
		if initFlag&vizconnect.INIT_ANIMATOR:
			# need to get the raw tracker dict for animating the avatars
			from vizconnect.util.avatar import animator
			from vizconnect.util.avatar import skeleton
			
			# get the skeleton from the avatar
			_skeleton = skeleton.Disembodied(rawAvatar[_name])
			
			#VC: set which trackers animate which body part
			# format is: bone: (tracker, parent, degrees of freedom used)
			_trackerAssignmentDict = {
				vizconnect.AVATAR_HEAD:(vizconnect.getTracker('zspace_eyes').getNode3d(), None, vizconnect.DOF_6DOF),
				vizconnect.AVATAR_R_HAND:(vizconnect.getTracker('zspace_wand').getNode3d(), None, vizconnect.DOF_6DOF),
			}
			
			#VC: create the raw object
			_rawAnimator = animator.Disembodied(rawAvatar[_name], _skeleton, _trackerAssignmentDict)
			
			#VC: set animator in wrapper (DO NOT EDIT)
			vizconnect.getAvatar(_name).setAnimator(_rawAnimator, make='Virtual', model='Disembodied')
	
		#VC: set the parent of the node
		if initFlag&vizconnect.INIT_PARENTS:
			vizconnect.getAvatar(_name).setParent(vizconnect.getGroup('zspace'))

	#VC: return values can be modified here
	return None


#################################
# Application Settings
#################################

def initSettings():
	#VC: apply general application settings
	viz.mouse.setTrap(False)
	viz.mouse.setVisible(viz.MOUSE_AUTO_HIDE)
	vizconnect.setMouseTrapToggleKey('')
	
	#VC: return values can be modified here
	return None


#################################
# Post-initialization Code
#################################

def postInit():
	"""Add any code here which should be called after all of the initialization of this configuration is complete.
	Returned values can be obtained by calling getPostInitResult for this file's vizconnect.Configuration instance."""
	return None


#################################
# Stand alone configuration
#################################

def initInterface():
	#VC: start the interface
	vizconnect.interface.go(__file__,
							live=True,
							openBrowserWindow=True,
							startingInterface=vizconnect.interface.INTERFACE_ADVANCED)

	#VC: return values can be modified here
	return None


###############################################

if __name__ == "__main__":
	initInterface()
	viz.add('piazza.osgb')

