﻿import viz
import vizconnect
import vizhtml

vizconnect.go('vizconnect_config.py')

viz.move([0,0,-5])

viz.add('sky_day.osgb')
mini = viz.addChild('mini.osg')
viz.link(vizconnect.getTransport().getNode3d(),mini)

code = """
<html>
<head>
    <title>vizhtml WebSocket Example</title>
    <script type="text/javascript" src="vizhtml.js"></script>
    <script type="text/javascript" src="jquery.js"></script>
    <style type="text/css">
    .overlay
    {
      position : absolute;
      visibility : hidden;
      z-index : 2;
    }

      .main {
      border: 1px solid black;
      box-shadow: 10px 10px 5px #888;
      border-radius: 12px;
      padding: 20px;
      background-color: #ddd;
      margin: 25px;
      width: 450px;
      margin-left:auto;
      margin-right:auto;  
    }
    

    .container {
      -webkit-perspective: 300; 
      perspective: 300;
    }

	.divider{
		width:10px;
		height:auto;
		display:inline-block;
	}

	</style>
</head>
<body>
 <div class="main">
      <h2>Device Orientation</h2>
      <table>
        <tr>
          <td>Event Supported</td>
          <td id="doEvent"></td>
        </tr>
        <tr>
          <td>Tilt Left/Right [gamma]</td>
          <td id="doTiltLR"></td>
        </tr>
        <tr>
          <td>Tilt Front/Back [beta]</td>
          <td id="doTiltFB"></td>
        </tr>
        <tr>
          <td>Direction [alpha]</td>
          <td id="doDirection"></td>
        </tr>        
        <tr>
          <td>Turn Left or Right</td>
          <td id="doLeftRight"></td>
        </tr>

    </table>

<script language="javascript">

    function deviceOrientationHandler(tiltLR, tiltFB, dir) {
      document.getElementById("doTiltLR").innerHTML = Math.round(tiltLR);
      document.getElementById("doTiltFB").innerHTML = Math.round(tiltFB);
      document.getElementById("doDirection").innerHTML = Math.round(dir);
      
      return tiltLR;
 }  

var socket = new viz.WebSocket();

		if (window.DeviceOrientationEvent) {
		document.getElementById("doEvent").innerHTML = "DeviceOrientation";
		// Listen for the deviceorientation event and handle the raw data
		window.addEventListener('deviceorientation', function(eventData) {		
		
		// gamma is the left-to-right tilt in degrees, where right is positive
		var tiltLR = eventData.gamma;
		
		// beta is the front-to-back tilt in degrees, where front is positive
		var tiltFB = eventData.beta;
		
		// alpha is the compass direction the device is facing in degrees
		var dir = eventData.alpha
		

		link=$("#orient0").click(function() {
		 socket.send( 'orient0' , viz.Data({'Rotation':[Math.round(eventData.gamma),Math.round(eventData.beta),Math.round(eventData.alpha)]}) );
		});

		if ((Math.round(eventData.beta) != 0) || (Math.round(eventData.gamma) != 0)){
		link.triggerHandler('click');
		}

		// call our orientation event handler
		deviceOrientationHandler(tiltLR, tiltFB, dir);
		}, false);
		} else {
		document.getElementById("doEvent").innerHTML = "Not supported on your device or browser.  Sorry."
		}

socket.onevent('open', function(e){
    document.getElementById('status').innerHTML = 'connected';
    document.getElementById('my_button').disabled = false;
})

socket.onevent('close', function(e){
    document.getElementById('status').innerHTML = 'waiting for connection';
    document.getElementById('my_button').disabled = true;
    socket.reconnect();
})


</script>

<div>Status:</div><div id='status'>waiting for connection</div></br>
<div><input id='orient0' type=button value="orient 0"></div></br>
</body>
</html>
"""

# http://localhost:8080/vizhtml/websocket
vizhtml.registerCode('websocket',code)

def ClientConnect(e):
    print 'Client connected at',e.client.address
vizhtml.onConnect(ClientConnect)

def ClientDisconnect(e):
    print 'Client disconnected at',e.client.address
vizhtml.onDisconnect(ClientDisconnect)

def Orient_0(e):
	"""Orient 0"""
	test_rotation = e.data.Rotation
vizhtml.onMessage('orient0',Orient_0)



class HTMLButtonInput(viz.EventClass):
    """Create input device from HTML Button
    
    @param buttonID: This should match the ID of the button in the HTML code
    """
    def __init__(self,buttonID):
        #Call super class constructor
        viz.EventClass.__init__(self)
        self.buttonID = buttonID
        self.isDown = False
        self.isUp = False
        self.isLeft = False
        self.isRight = False
        
        # setup callbacks so we're notified when the state changes
        self.callback(vizhtml.MESSAGE_EVENT, self.onMessage)
    
    
    def onMessage(self, e):
        test_rotation = e.data.Rotation

        if -4 > test_rotation[1]:
               self.isDown = True
        else:
          self.isDown = False
        if 25 < test_rotation[1]:
               self.isUp = True
        else:
          self.isUp = False
                
        if -4 > test_rotation[0]:
               self.isLeft = True
        else:
          self.isLeft = False
        if 25 < test_rotation[0]:
               self.isRight = True
        else:
          self.isRight = False
                
forwardButton = HTMLButtonInput('orient0')

#Set the update function which checks for input signals
def update(transport):
	if forwardButton.isDown:
		transport.moveForward(mag=1)
	if forwardButton.isUp:
		transport.moveBackward(mag=1)
	if forwardButton.isLeft:
		transport.turnLeft(mag=1)
	if forwardButton.isRight:
		transport.turnRight(mag=1)
vizconnect.getTransport().getRaw().setUpdateFunction(update)