﻿import viz
import vizconnect
import vizhtml

vizconnect.go('vizconnect_config.py')

viz.move([0,0,-5])

viz.add('sky_day.osgb')
mini = viz.addChild('mini.osg')
viz.link(vizconnect.getTransport().getNode3d(),mini)

code = """
<html>
<head>
    <title>vizhtml WebSocket Example</title>
    <script type="text/javascript" src="vizhtml.js"></script>
</head>
<body>
<script language="javascript">

var socket = new viz.WebSocket();

socket.onevent('open', function(e){
    document.getElementById('status').innerHTML = 'connected';
    document.getElementById('my_button').disabled = false;
})

socket.onevent('close', function(e){
    document.getElementById('status').innerHTML = 'waiting for connection';
    document.getElementById('my_button').disabled = true;
    socket.reconnect();
})

function onMouseDown(button)
{
    socket.send( 'button_down', viz.Data({'id':button.id}) );
}

function onMouseUp(button)
{
    socket.send( 'button_up', viz.Data({'id':button.id}) );
}

</script>

<div>Status:</div><div id='status'>waiting for connection</div></br>
<div><input id='forward' type=button value="Forward" onmousedown="onMouseDown(this);" onmouseup="onMouseUp(this);"></div></br>
<div><input id='back' type=button value="Back" onmousedown="onMouseDown(this);" onmouseup="onMouseUp(this);" ></div></br>
</body>
</html>
"""

# http://localhost:8080/vizhtml/websocket
vizhtml.registerCode('websocket',code)

def ClientConnect(e):
    print 'Client connected at',e.client.address
vizhtml.onConnect(ClientConnect)

def ClientDisconnect(e):
    print 'Client disconnected at',e.client.address
vizhtml.onDisconnect(ClientDisconnect)


class HTMLButtonInput(viz.EventClass):
    """Create input device from HTML Button
    
    @param buttonID: This should match the ID of the button in the HTML code
    """
    def __init__(self,buttonID):
        #Call super class constructor
        viz.EventClass.__init__(self)
        self.buttonID = buttonID
        self.isDown = False
        
        # setup callbacks so we're notified when the state changes
        self.callback(vizhtml.MESSAGE_EVENT, self.onMessage)
    
    
    def onMessage(self, e):
        
        if self.buttonID == e.data.id:
            if e.event == 'button_up':
               self.isDown = False
            elif e.event == 'button_down':
                self.isDown = True
                
forwardButton = HTMLButtonInput('forward')
backButton = HTMLButtonInput('back')

#Set the update function which checks for input signals
def update(transport):
	if forwardButton.isDown:
		transport.moveForward(mag=1)
	if backButton.isDown:
		transport.moveBackward(mag=1)
		
vizconnect.getTransport().getRaw().setUpdateFunction(update)