import viz
viz.go()


white_ball = viz.add('white_ball.wrl')

red_ball = viz.add('white_ball.wrl')
red_ball.color(viz.RED)
		
class TargetUpdater:
	def __init__(self):
		self.__targets = []
		
	def addTarget(self,node,weight):
		node.weight = weight
		self.__targets.append(node)
		
	def update(self,pos):
		#Iterate through targets
		newPos = viz.Vector(pos)
		startPos = viz.Vector(pos)
		for t in self.__targets:
			v = viz.Vector(t.get(viz.POSITION))
			v = v - startPos
			d = max(v.length(),0.4)
			v.normalize()
			v *= t.weight*0.1/d
			newPos += v
		return newPos.get()

tu = TargetUpdater()

t1 = viz.add('white_ball.wrl')
t1.color(viz.GREEN)

t2 = viz.add('white_ball.wrl')
t2.color(viz.GREEN)

t1.translate(-1,0,1)
t2.translate(1,0,1)

tu.addTarget(t1,3)
tu.addTarget(t2,3)

def ontimer(num):
	if viz.iskeydown(viz.KEY_LEFT):
		white_ball.translate(-1*viz.elapsed(),0,0,viz.RELATIVE)
	elif viz.iskeydown(viz.KEY_RIGHT):
		white_ball.translate(1*viz.elapsed(),0,0,viz.RELATIVE)
	if viz.iskeydown(viz.KEY_UP):
		white_ball.translate(0,0,1*viz.elapsed(),viz.RELATIVE)
	elif viz.iskeydown(viz.KEY_DOWN):
		white_ball.translate(0,0,-1*viz.elapsed(),viz.RELATIVE)

	pos = tu.update(white_ball.get(viz.POSITION))
	red_ball.translate(pos)

viz.callback(viz.TIMER_EVENT,ontimer)
viz.starttimer(0,0,viz.FOREVER)

viz.move(0,4,-0.1)
viz.lookat(0,0,0)