import viz
import vizmat
import new

_hd_ = viz.add('hd.dlm')
_marker_ = 0
_drag_ = []

class _HDUPDATE_(viz.EventClass):
	
	def __init__(self):
		viz.EventClass.__init__(self)
		self.callback(viz.TIMER_EVENT,self.mytimer)
		self.starttimer(0,0.01,viz.FOREVER)
		
	def mytimer(self,num):
		_hd_.command(0)
		
		if _marker_ or len(_drag_) > 0:
			hdpos = viz.Vector(get(POSITION))
			hdrot = viz.Quat(get(ROTATION))
			
		if _marker_:
			_marker_.translate(hdpos.x,hdpos.y,hdpos.z)
			_marker_.rotatequat(hdrot.x,hdrot.y,hdrot.z,hdrot.w)
			
		for obj in _drag_:

			dragDeltaTrans = viz.Transform()
			deltaRotMat = viz.Transform()
			
			if obj._hd_drag_option_ & DRAG_POSITION:
				dragDeltaTrans.setTrans( (hdpos - obj._hd_start_proxy_pos_).get() )
			
			if obj._hd_drag_option_ & DRAG_ROTATION:
				temp = obj._hd_start_proxy_ori_.inverse()
				
				dragDeltaRot = temp * hdrot
				
				dragDeltaRot.normalize()
			
				deltaRotMat.setRot(vizmat.QuatToAxisAngle(dragDeltaRot.get()))
				
				toProxy = viz.Transform()
				toProxy.setTrans((obj._hd_start_proxy_pos_*-1).get())
				
				fromProxy = viz.Transform()
				fromProxy.setTrans(obj._hd_start_proxy_pos_.get())
				
				deltaRotMat = toProxy * deltaRotMat * fromProxy
			
			deltaMat = deltaRotMat * dragDeltaTrans
		
			final = obj._hd_start_xform_ * deltaMat
	
			obj.translate(final.getTrans())
			obj.rotate(final.getRot())
			
			
if _hd_.valid():		
	_updater_ = _HDUPDATE_()

#Haptic object type
MESH	= 0
POINTS	= 1

#Events
BUTTONDOWN_EVENT	= 0
BUTTONUP_EVENT		= 1
TOUCH_EVENT			= 2
UNTOUCH_EVENT		= 3

#Return values
TOUCH_OBJECTS	= -2
DRAG_OBJECTS	= -1
POSITION		= 1
ROTATION		= 2
BUTTON1			= 4
BUTTON2			= 5
TOUCH_OBJECT	= 6
FORCE			= 11
TOUCH_NORMAL	= 12
TORQUE			= 13
TOUCH_COUNT		= 16

#Material values
STIFFNESS			= 0
DAMPING				= 1
STATIC_FRICTION		= 2
DYNAMIC_FRICTION	= 3

#Drag options
DRAG_POSITION	= 1
DRAG_ROTATION	= 2
DRAG_ALL		= DRAG_POSITION | DRAG_ROTATION

#Maps a return type to the size of data it returns
_returnMap_ = {}
_returnMap_[POSITION]		= 3
_returnMap_[ROTATION]		= 4
_returnMap_[BUTTON1]		= 1
_returnMap_[BUTTON2]		= 1
_returnMap_[FORCE]			= 3
_returnMap_[TOUCH_NORMAL]	= 3
_returnMap_[TORQUE]			= 3
_returnMap_[TOUCH_COUNT]	= 1

#Maps a haptic id to a node id
_nodeMap_ = {}

_buttondowncb_	= 0
_buttonupcb_	= 0
_touchcb_		= 0
_untouchcb_		= 0

def _buttondowncallback_(button):
	if _buttondowncb_:
		_buttondowncb_(button)
		
def _buttonupcallback_(button):
	if _buttonupcb_:
		_buttonupcb_(button)

def _touchcallback_(id):
	if _touchcb_ and _nodeMap_.has_key(id):
		_touchcb_(_nodeMap_[id])
		
def _untouchcallback_(id):
	if _untouchcb_ and _nodeMap_.has_key(id):
		_untouchcb_(_nodeMap_[id])

def callback(event,function):
	"""Set a callback for haptic events"""
	global _buttondowncb_,_buttonupcb_,_touchcb_,_untouchcb_
	
	if event == BUTTONDOWN_EVENT:
		_buttondowncb_ = function
	elif event == BUTTONUP_EVENT:
		_buttonupcb_ = function
	elif event == TOUCH_EVENT:
		_touchcb_ = function
	elif event == UNTOUCH_EVENT:
		_untouchcb_ = function

def drag(object, option = DRAG_ALL):
	"""Use the haptic pen to drag the object"""
	if object not in _drag_ and object.valid():
		_drag_.append(object)

		pos = object.get(viz.POSITION)
		ori = object.get(viz.AXISANGLE)
		
		object._hd_start_proxy_pos_ = viz.Vector(get(POSITION))
		object._hd_start_proxy_ori_ = viz.Quat(get(ROTATION))
		object._hd_start_xform_ = viz.Transform()
		object._hd_start_xform_.setTrans(pos)
		object._hd_start_xform_.setRot(ori)
		
		object._hd_drag_option_ = option
		
		
def undrag(object=-1):
	"""Stop the haptic pen from dragging the object"""
	if object == -1:
		del _drag_[:]
	elif object in _drag_:
		_drag_.remove(object)

def marker(object):
	"""Set a marker to represent the haptic pen"""
	global _marker_
	_marker_ = object

def translate(x,y=0,z=0):
	"""Translate the workspace"""
	if type(x) == type([]):
		_hd_.command(8,'',x[0],x[1],x[2])
	else:
		_hd_.command(8,'',x,y,z)
		
def scale(x,y=0,z=0):
	"""Scale the workspace"""
	if type(x) == type([]):
		_hd_.command(9,'',x[0],x[1],x[2])
	else:
		_hd_.command(9,'',x,y,z)
	
def rotate(x,y=0,z=0,deg=''):
	"""Rotate the workspace"""
	if type(x) == type([]):
		if len(x) == 3:
			quat = vizmat.EulerToQuat(x)
		else:
			quat = vizmat.AxisAngleToQuat(x)
	else:
		if deg == '':
			quat = vizmat.EulerToQuat(x,y,z)
		else:
			quat = vizmat.AxisAngleToQuat(x,y,z,deg)
	_hd_.command(10,'',quat[0],quat[1],quat[2],quat[3])
	
def rotatequat(x,y=0,z=0,w=0):
	"""Rotate the workspace in quaternions"""
	if type(x) == type([]):
		_hd_.command(10,'',x[0],x[1],x[2],x[3])
	else:
		_hd_.command(10,'',x,y,z,w)
	
def _gettouchobject_(index):
	"""Return an object that is currently begin touched"""
	_hd_.command(TOUCH_OBJECT,'',index)
	touchID = _hd_.get()[0]
	if _nodeMap_.has_key(touchID):
		return _nodeMap_[touchID]
	return viz.VizNode(-1)
	
def get(what):
	"""Query haptic device for certain state values"""
	if what == DRAG_OBJECTS:
		return _drag_
	elif what == TOUCH_OBJECTS:
		size = int(get(TOUCH_COUNT))
		touchlist = []
		for x in range(size):
			touchlist.append(_gettouchobject_(x))
		return touchlist
	elif what == TOUCH_OBJECT:
		return _gettouchobject_(0)
	elif _returnMap_.has_key(what):
		_hd_.command(what)
		size = _returnMap_[what]
		if size == 1:
			return _hd_.get()[0]
		return _hd_.get()[:size]
	return 0
	
def add(node,mode=MESH):
	"""Add the node to the haptic environment"""
	node.modify(_hd_,mode)
	#Get the haptic id for the node
	node._hapticID_ = _hd_.get()[0]
	#Map the haptic id to the actual node for later usage
	_nodeMap_[node._hapticID_] = node
	
	#Dynamically add methods to node
	node.refresh = new.instancemethod(_refresh_, node, viz.VizNode)
	node.stiffness = new.instancemethod(_stiffness_, node, viz.VizNode)
	node.damping = new.instancemethod(_damping_, node, viz.VizNode)
	node.staticfriction = new.instancemethod(_staticfriction_, node, viz.VizNode)
	node.dynamicfriction = new.instancemethod(_dynamicfriction_, node, viz.VizNode)
	node.dynamicmesh = new.instancemethod(_dynamicmesh_, node, viz.VizNode)
	node.enablehd = new.instancemethod(_enablehd_, node, viz.VizNode)
	
def _refresh_(self):
	"""Notify the haptic environment that the objects mesh has changed"""
	_hd_.command(7,'',self._hapticID_)
	
def _stiffness_(self,value):
	"""Stiffness controls how hard surfaces feel. Param must be a value between 0 and 1 where 1
represents the hardest surface the haptic device is capable of rendering and 0 represents the
most compliant surface that can be rendered."""
	_hd_.command(3,'',self._hapticID_,STIFFNESS,value)
	
def _damping_(self,value):
	"""Damping reduces the springiness of the surface. Param must be between 0 and 1 where 0
represents no damping, i.e. a highly springy surface and 1 represents the maximum level of
damping possible"""
	_hd_.command(3,'',self._hapticID_,DAMPING,value)
	
def _staticfriction_(self,value):
	"""Static friction controls the resistance of a surface to tangential motion when the proxy
position is not changing i.e. how hard it is to slide along the surface starting from a complete
stop. A param value of 0 is a completely frictionless surface and a value of 1 is the
maximum amount of static friction the haptic device is capable of rendering."""
	_hd_.command(3,'',self._hapticID_,STATIC_FRICTION,value)
	
def _dynamicfriction_(self,value):
	"""Dynamic friction controls the resistance of a surface to tangential motion when the proxy
position is changing i.e. how hard it is to slide along the surface once already moving. A
param value of 0 is a completely frictionless surface and a value of 1 is the maximum
amount of dynamic friction the haptic device is capable of rendering."""
	_hd_.command(3,'',self._hapticID_,DYNAMIC_FRICTION,value)

def _dynamicmesh_(self,value):
	"""Notify the haptic controller whether the objects mesh is dynamic"""
	_hd_.command(14,'',self._hapticID_,value)
	
def _enablehd_(self,value):
	"""Enable/Disable the haptic object"""
	_hd_.command(15,'',self._hapticID_,value)

#Effect types
EFFECT_CONSTANT		= 0
EFFECT_SPRING		= 1
EFFECT_VISCOUS		= 2
EFFECT_FRICTION		= 3

class Effect(object):
	def __init__(self,type,gain=None,mag=None,pos=None,dir=None):
		#Create effect id
		_hd_.command(17)
		self.id = _hd_.get()[0]
		#Save type
		self.__type = type
		
		if gain is not None:
			self.setGain(gain)
		if mag is not None:
			self.setMagnitude(mag)
		if pos is not None:
			self.setPosition(pos)
		if dir is not None:
			self.setDirection(dir)

	def remove(self):
		"""Delete effect"""
		_hd_.command(18,'',self.id)
		
	def start(self):
		"""Start an effect"""
		_hd_.command(19,'',self.id,self.__type)
		
	def stop(self):
		"""Stop the effect"""
		_hd_.command(20,'',self.id)
		
	def trigger(self,duration):
		"""Trigger the effect for the specified duration"""
		_hd_.command(21,'',self.id,self.__type,duration)
		
	def setGain(self,gain):
		"""Set gain of effect"""
		_hd_.command(22,'',self.id,gain)
		
	def setMagnitude(self,mag):
		"""Set magnitude of effect"""
		_hd_.command(23,'',self.id,mag)
		
	def setPosition(self,pos):
		"""Set the position of the effect"""
		_hd_.command(24,'',self.id,pos[0],pos[1],pos[2])
		
	def setDirection(self,dir):
		"""Set the direction of the effect"""
		_hd_.command(25,'',self.id,dir[0],dir[1],dir[2])
		
	
class ConstantEffect(Effect):
	def __init__(self,**kw):
		Effect.__init__(self,EFFECT_CONSTANT,**kw)
		
class SpringEffect(Effect):
	def __init__(self,**kw):
		Effect.__init__(self,EFFECT_SPRING,**kw)
		
class ViscousEffect(Effect):
	def __init__(self,**kw):
		Effect.__init__(self,EFFECT_VISCOUS,**kw)
		
class FrictionEffect(Effect):
	def __init__(self,**kw):
		Effect.__init__(self,EFFECT_FRICTION,**kw)
