import viz
viz.go()

viz.add('tut_ground.wrl')
viz.clearcolor(viz.GRAY)
viz.move(0,0,-7)

import vizinfo
vizinfo.add('Press spacebar to toggle a friction effect')

marker = viz.add('marker.wrl')

import hd
hd.marker(marker)

""" The following description is from the OpenHaptics documentation:
	
Adds a friction force to the total force sent to the haptic device. Unlike friction specified via
hlMaterial calls, this is friction both while touching objects and in free space. The gain of the
friction force is specified by the property HL_EFFECT_PROPERTY_GAIN. The
magnitude of the effect force is capped at the value of the effect property
HL_EFFECT_MAGNITUDE.

"""

fe = hd.FrictionEffect(gain=0.2,mag=0.5)
fe.started = False

def onKeyDown(key):
	if key == ' ':
		fe.started = not fe.started
		if fe.started:
			fe.start()
		else:
			fe.stop()
viz.callback(viz.KEYDOWN_EVENT,onKeyDown)
