import viz
viz.go()

viz.add('tut_ground.wrl')
viz.clearcolor(viz.GRAY)
viz.move(0,0,-7)

import vizinfo
vizinfo.add('Press the haptic button to trigger a constant force effect')

marker = viz.add('marker.wrl')

import hd
hd.marker(marker)

""" The following description is from the OpenHaptics documentation:
	
Adds a constant force vector to the total force sent to the haptic device. The effect property
HL_EFFECT_PROPERTY_DIRECTION specifies the direction of the force vector. The
effect property HL_EFFECT_PROPERTY_MAGNITUDE specifies the magnitude of the
force vector.

"""

ce = hd.ConstantEffect(dir=[0,0,-1],mag=1)

def hdbuttondown(button):
	#Apply a force for 0.1 seconds when button is presesd
	if button == hd.BUTTON1:
		ce.trigger(0.1)

hd.callback(hd.BUTTONDOWN_EVENT,hdbuttondown)


