import viz
viz.go()

viz.add('tut_ground.wrl')
viz.clearcolor(viz.GRAY)
viz.move(0,0,-7)

import vizinfo
vizinfo.add('Press spacebar to toggle a viscous effect')

marker = viz.add('marker.wrl')

import hd
hd.marker(marker)

""" The following description is from the OpenHaptics documentation:
	
Adds a viscous force to the total force sent to the haptic device. The viscous force is based
on the current velocity of the haptic device and is calculated to resist the motion of the haptic
device. Specifically the force is calculated using the expression F = -kV where f is the spring
force, V is the velocity and k is the gain. The gain is specified by the property
HL_EFFECT_PROPERTY_GAIN. The magnitude of the effect force is capped at the value
of the effect property HL_EFFECT_MAGNITUDE.

"""

ve = hd.ViscousEffect(gain=0.7,mag=1.0)
ve.started = False

def onKeyDown(key):
	if key == ' ':
		ve.started = not ve.started
		if ve.started:
			ve.start()
		else:
			ve.stop()
viz.callback(viz.KEYDOWN_EVENT,onKeyDown)
