import viz
viz.go()

viz.add('tut_ground.wrl')
viz.clearcolor(viz.GRAY)
viz.move(0,0,-7)

import vizinfo
vizinfo.add('Press the haptic button to start a spring effect')

marker = viz.add('marker.wrl')

import hd
hd.marker(marker)

""" The following description is from the OpenHaptics documentation:
	
Adds a spring force to the total force sent to the haptic device. The spring force pulls the
haptic device towards the effect position and is proportional to the product of the gain and
the distance between the effect position and the device position. Specifically, the spring
force is calculated using the expression F = k(P-X) where F is the spring force, P is the effect
position, X is the current haptic device position and k is the gain. The effect position is
specified by the property HL_EFFECT_PROPERTY_POSITION. The gain is specified by
the property HL_EFFECT_PROPERTY_GAIN. The magnitude of the effect force is capped
at the value of the effect property HL_EFFECT_MAGNITUDE.

"""

se = hd.SpringEffect(gain=0.2,mag=0.5)

#Create line to show spring effect
viz.startlayer(viz.LINES)
viz.vertexcolor(viz.RED)
viz.linewidth(2)
viz.vertex(0,0,0)
viz.vertex(0,0,0)
line = viz.endlayer()
line.visible(0)
line.dynamic()

def hdbuttondown(button):
	#Start the spring effect when button 1 is pressed
	if button == hd.BUTTON1:
		pos = hd.get(hd.POSITION)
		se.setPosition(pos)
		se.start()
		line.visible(1)
		line.vertex(0,pos)
		line.vertex(1,pos)
		viz.starttimer(0,0,viz.FOREVER)
		
def hdbuttonup(button):
	#Stop the spring effect when button 1 is released
	if button == hd.BUTTON1:
		se.stop()
		line.visible(0)
		viz.killtimer(0)
		
hd.callback(hd.BUTTONDOWN_EVENT,hdbuttondown)
hd.callback(hd.BUTTONUP_EVENT,hdbuttonup)


def onTimer(num):
	line.vertex(1,hd.get(hd.POSITION))
viz.callback(viz.TIMER_EVENT,onTimer)
