import viz
import vizact
import types

class VizSpeakAction(viz.ActionClass):

	def begin(self,object):
		self.avnumbers = self._actiondata_.data[0]
		self.length = self._actiondata_.data[1]
		self.morph = self._actiondata_.data[2]
		self.audio = self._actiondata_.data[3]
		self.scale = self._actiondata_.data[4]
		self.thresh = self._actiondata_.data[5]
		self.numsamples = len(self.avnumbers)
		self.elapsed = 0
		self.bone = 0
		self.boneoffset = 0
		self.lastsync = 0
		
		if object._face_:
			if type(self.morph) == types.StringType:
				self.morph = object._face_.getmorph(self.morph)
		else:
			self.bone = object.getbone('skel_Jaw')
			if not self.bone:
				self.end(object)
				return
			self.bone.lock()
			self.boneoffset = self.bone.get(viz.AXISANGLE)[3]
			
		if self.length <= 0.0:
			self.end(object)
		else:
			self.audio.stop()
			self.audio.play()

	def update(self,elapsed,object):

		if self.finished():
			return

		self.elapsed += elapsed
	
		self.lastsync += elapsed
		
		#Resync mouth with audio every 5 seconds
		if self.lastsync > 5.0:
			self.elapsed = self.audio.getposition()
			self.lastsync = 0.0
	
		p = self.elapsed / self.length
		
		if p > 1:
			self.end(object)
			return
		
		sample = int(p * self.numsamples)
		value = self.avnumbers[sample]
		
		if value < self.thresh:
			value = 0
		
		if self.bone:
			self.bone.rotate(1,0,0,value*self.scale*10+self.boneoffset)
		else:
			object._face_.morph(self.morph,value*self.scale)		
		
	def end(self,object):
		if not self.finished():
			self.audio.stop()
			if self.bone:
				self.bone.unlock()
			else:
				object._face_.morph(self.morph,0)
			self._completed_ = 1

def __speak_sync(filename, scale=1.0, morph='mouth_open', threshold = 0):
	import vizwave
	#Get wave data
	data = vizwave.getdata(filename)
	
	#The averaged data
	avnumbers = []
	
	#The length of the wave in seconds
	length = 0
	
	if data:
		
		#length of wave in seconds
		length = data[1]
		
		#Number of samples in wave file
		numsamples = len(data[0])
		
		#Temp variables
		counti = 0
		sumi = 0.0
		interval = 400
		
		#Go through data array. Average every 5th sample for 400 samples at a time
		for x in range(0, numsamples, 5):
			counti += 1
			sumi = sumi + abs((data[0][x]-128.0)/20.0)
			if counti % interval == 0:
				meani = sumi / interval
				avnumbers.append(meani)
				counti = 0
				sumi = 0.0
		
		# calculate default threshold, otherwise provided threshold is used
		if threshold < 0:
			sum = 0
			for value in avnumbers:
				sum = sum + value
			threshold = sum / len(avnumbers)	# average value of the array

	bla = viz.ActionData()
	bla.data = [avnumbers,length,morph,viz.add(filename),scale,threshold]
	bla.actionclass = VizSpeakAction
	return bla

viz.upgradeModule(vizact,'speak_sync',__speak_sync)