import viz
import vizmat

HEAD_NEUTRAL	= 0
HEAD_NODDING	= 1
HEAD_SHAKING	= 2

HEAD_MOTION_EVENT = viz.eventid('HeadMotionDetectorEvent')

class HeadMotionDetector(viz.EventClass):
	
	def __init__(self, view = viz.get(viz.MAIN_VIEWPOINT)):
		viz.EventClass.__init__(self)
		
		self.__view = view
		self.__sampleSize = 20
		self.__rotationHistory = []
		self.__state = HEAD_NEUTRAL
		
		self.callback(viz.TIMER_EVENT,self.__ontimer)
		self.starttimer(0,0.2,viz.FOREVER)
		self.starttimer(1,1,viz.FOREVER)
		
	def __ontimer(self,num):
		if num == 0:
			#Store sample
			self.__rotationHistory.append(self.__view.get(viz.HEAD_EULER))
			if len(self.__rotationHistory) > self.__sampleSize:
				del self.__rotationHistory[0]
		elif num == 1:
			#Analyze samples
			numYawChanges = 0
			numPitchChanges = 0
			lastYawDir = 0
			lastPitchDir = 0
			for x in range(len(self.__rotationHistory)-1):
				yawDiff = vizmat.AngleDiff(self.__rotationHistory[x][0],self.__rotationHistory[x+1][0])
				pitchDiff = vizmat.AngleDiff(self.__rotationHistory[x][1],self.__rotationHistory[x+1][1])
				
				if abs(yawDiff) > 15.0:
					curDir = viz.sign(yawDiff)	
					if lastYawDir != curDir and lastYawDir != 0:
						numYawChanges += 1
					lastYawDir = curDir
					
				if abs(pitchDiff) > 10.0:
					curDir = viz.sign(pitchDiff)
					if lastPitchDir != curDir and lastPitchDir != 0:
						numPitchChanges += 1
					lastPitchDir = curDir
				
			if numYawChanges > 2:
				newState = HEAD_SHAKING
			elif numPitchChanges > 2:
				newState = HEAD_NODDING
			else:
				newState = HEAD_NEUTRAL
				
			if newState != self.__state:
				viz.sendevent(HEAD_MOTION_EVENT,newState,self.__state,self)
				self.__state = newState

		def clearState(self):
			self.__state = HEAD_NEUTRAL
			del self.__rotationHistory[:]
			
		def getState(self):
			return self.__state
