﻿#Demo_Optic

viz.setOption('viz.window.width', 1600 )
viz.setOption('viz.window.height', 900 )
viz.setOption('viz.antialias', 2 )
viz.setOption('viz.setMultiSample', 4 )
viz.setOption('viz.vsync', 1 )
viz.setOption('viz.fullscreen.monitor', 1)

viz.go()

#Viewpoint start position
viz.MainView.setPosition(-5.21,  1.14,  0.32)
viz.MainView.setEuler( 90.49,  -0.00,   0.00)

viz.clearcolor(viz.SKYBLUE, alpha=0.0)

model = viz.add('Demo_Optic.osgb')

#Optic Position
t_matrix = viz.Matrix() 
t_matrix.setPosition([3, 1, 0])
t_matrix.setScale([1, 1, 1])
t_matrix.setEuler([-90, 0, 0])

#Optic Size
Display = viz.addTexQuad(scale=[2, 2, 2], pos=t_matrix.getPosition(), euler=t_matrix.getEuler())
r_node = Display
r_tex = viz.addRenderTexture()

#Optic Material
r_lens = viz.addRenderNode(size=[1024, 1024])
r_lens.setRenderLimit(viz.RENDER_LIMIT_FRAME)
r_lens.attachTexture(r_tex)
r_lens.setInheritView(True, viz.POST_MULT)
r_lens.enable(viz.FLIP_POLYGON_ORDER,op=viz.OP_OVERRIDE)
r_lens.enable(viz.SAMPLE_ALPHA_TO_COVERAGE,op=viz.OP_OVERRIDE)
r_lens.renderToEye(viz.BOTH_EYE)
r_lens.renderToAllRenderNodesExcept([r_node])

#Optic Viewpoint calculation
r_tmatrix = t_matrix.getMatrix()
r_quaternion = r_tmatrix.getQuat()
r_rot = viz.Matrix.quat(r_quaternion)
r_invRot = r_rot.inverse()
r_pos = viz.Vector(r_tmatrix.getPosition())
r_dir = viz.Vector(r_tmatrix.getForward())
r_dir.normalize()

#Optic Projection calculation
r_lens.setMatrix(viz.Matrix.translate(-r_pos)*r_invRot*viz.Matrix.scale(1,1,-1)*r_rot*viz.Matrix.translate(r_pos)) 
# Z = Translate(T, -V_POS) * ROT * Scale(T) * ROT^-1 * Translate(T, +V_POS)
s = viz.sign(viz.Vector(r_dir) * viz.Vector(r_pos))
r_plane = vizmat.Plane(pos=r_pos,normal=r_dir)
r_dist = r_plane.distance([0,0,0])
r_lens.clipPlane([r_dir[0],r_dir[1],r_dir[2],s*r_dist-0.01])

#Place Optic Projection
r_node.texture(r_tex)
r_node.disable(viz.LIGHTING)
r_node.texGen(viz.TEXGEN_PROJECT_EYE)
r_node.renderToAllRenderNodesExcept([r_lens])
#r_node.enable(viz.SAMPLE_ALPHA_TO_COVERAGE)