import viz

viz.go()

import vizinfo
info = vizinfo.add('PPT Simulation settings')
showLight = info.add(viz.CHECKBOX,'Show light number:')
showLight.set(1)
allWhite = info.add(viz.CHECKBOX,'All white:')
showBad = info.add(viz.CHECKBOX,'Bad lights black:')
info.shrink(1)

viz.add('tut_ground.wrl')
viz.move(0,0,-7)
viz.clearcolor(viz.GRAY)

numLights = viz.input('How many lights are you tracking?')
numLights = min(8,numLights)

colors =	[
				[0, 1, 0.545],
				[1, 0, 1],
				[0, 1, 1],
				[1, 1, 0.545],
				[1, 0, 0],
				[0, 0.545, 1],
				[1, 0.545, 0],
				[0.545, 0, 1],
			]

sensors = []
balls = []
labels = []

for x in range(numLights):
	
	#Create sensor
	ppt = viz.add('vizppt.dls')
	sensors.append(ppt)
	
	#Create ball
	ball = viz.add('white_ball.wrl')
	ball.scale(0.5,0.5,0.5)
	ball.color(colors[x])
	balls.append(ball)
	ball.link(ppt)
	ball.pptColor = colors[x]
	ball.curColor = colors[x]
	
	#Create label for ball
	text = ball.add(viz.TEXT3D,str(x+1))
	text.billboard()
	text.disable(viz.DEPTH_TEST)
	text.alignment(viz.TEXT_CENTER_CENTER)
	text.draworder(20)
	text.scale(0.1,0.1,0.1)
	labels.append(text)
	
def ontimer(num):
	for i in range(numLights):
		if sensors[i].get()[7]:
			ball.color(ball.curColor)
		else:
			ball.color(viz.BLACK)

viz.callback(viz.TIMER_EVENT,ontimer)

def onbutton(obj,state):
	if obj == showLight:
		for label in labels:
			label.visible(state)
	elif obj == allWhite:
		for ball in balls:
			if state:
				ball.curColor = viz.WHITE
			else:
				ball.curColor = ball.pptColor
			ball.color(ball.curColor)
	elif obj == showBad:
		viz.killtimer(0)
		if state:
			viz.starttimer(0,0,viz.FOREVER)

viz.callback(viz.BUTTON_EVENT,onbutton)
