import viz
import vizact
import viztask

viz.go()

avatar = viz.add('vcc_male2.cfg', pos = [0,.15,.25], euler = [180,0,0])
avatar.execute(1)
avatar.setAnimationTime(1,3.5)

eyeBlinkBoneList = ['Bip01 LEyeBlinkBottom', 'Bip01 LEyeBlinkTop']
boneMatList = []

# Create an object list for bones
boneObjList = []
for bones in eyeBlinkBoneList:
	boneObjList.append(avatar.getBone(bones))

def boneRec():
	boneMat = []
	for index, bones in enumerate(eyeBlinkBoneList):
		boneMat.append(boneObjList[index].getMatrix(viz.ABS_PARENT))
	boneMatList.append(boneMat)
		
def recTask():
	eventFunction = vizact.ontimer(0.016, boneRec)
	yield viztask.waitTime(0.5)
	vizact.removeEvent( eventFunction )

# Record the blink animation just after the program starts
viztask.schedule( recTask() )

def playback():
	def subTask():
		for bones in boneObjList:
			bones.lock()
		
		for matList in boneMatList:
			for index, mat in enumerate(matList):
				boneObjList[index].setMatrix(mat, viz.ABS_PARENT)
			yield None
				
		for bones in boneObjList:
			bones.unlock()
		
	viztask.schedule( subTask() )

# Press the space key for playing back the blink animation
vizact.onkeydown(' ', playback)