import viz
import vizmat


class SNNewBoth(viz.EventClass):

	PAN_SCALE = 3.0
	MOVE_SCALE = 3.0

	def __init__(self,view):
		viz.EventClass.__init__(self)
		

		self.__view =view #viz.get(viz.MAIN_VIEWPOINT)
		#self.__view.translate(0,1,-6)
		self.__center = [0,0,0]
		self.__lastmousepos = [0,0]
		self.callback(viz.TIMER_EVENT,self.__ontimer)
		self.callback(viz.MOUSEDOWN_EVENT,self.__onmousedown)
#		self.callback(viz.MOUSEUP_EVENT,self.__onmouseUp)
		self.callback(viz.MOUSEWHEEL_EVENT,self.__onmousewheel)
		self.starttimer(0,0,viz.FOREVER)

	def __ontimer(self,num):

		button = viz.buttonstate()
		mouse = viz.mousepos()
		if viz.iskeydown(viz.KEY_RIGHT):
			self.__view.rotate(self.__view.get(viz.HEAD_EULER)[0]+1,self.__view.get(viz.HEAD_EULER)[1],self.__view.get(viz.HEAD_EULER)[2])
		if viz.iskeydown(viz.KEY_LEFT):
			self.__view.rotate(self.__view.get(viz.HEAD_EULER)[0]-1,self.__view.get(viz.HEAD_EULER)[1],self.__view.get(viz.HEAD_EULER)[2])
		if viz.iskeydown(viz.KEY_SHIFT_L):
			if button & viz.MOUSEBUTTON_LEFT:
					self.panRight(-(mouse[0] - self.__lastmousepos[0])*self.PAN_SCALE)
					self.panUp(-(mouse[1] - self.__lastmousepos[1])*self.PAN_SCALE)
		if viz.iskeydown(viz.KEY_TAB):
			if button & viz.MOUSEBUTTON_LEFT:
					self.rotateRight((mouse[0] - self.__lastmousepos[0])*self.MOVE_SCALE)
					self.rotateUp((mouse[1] - self.__lastmousepos[1])*self.MOVE_SCALE)
#		if viz.iskeydown(viz.KEY_CONTROL_L):
#			if button & viz.MOUSEBUTTON_LEFT:
#				if mouse[1] - self.__lastmousepos[1]<0:
#					distance = vizmat.Distance(self.__view.get(viz.HEAD_POS),self.__center) / 8.0
#					self.__view.move(0,0,-1*distance)
#				if mouse[1] - self.__lastmousepos[1]>0:
#					distance = vizmat.Distance(self.__view.get(viz.HEAD_POS),self.__center) / 8.0
#					self.__view.move(0,0,1*distance)
		self.__lastmousepos = mouse

	def __onmousedown(self,button):

		if button == viz.MOUSEBUTTON_LEFT and viz.iskeydown(viz.KEY_SHIFT_R):
			
			info = viz.pick(1)
			
			if info.intersected:
				print 'info.intersectPoint',info.intersectPoint
				point=vizmat.Vector(0,0,0)
				self.setCenter(info.intersectPoint)
#	def __onmouseUp(self,button):
#		print 'up'
#		#viz.mouse(viz.ON)
			
				
	def __onmousewheel(self,dir):
		distance = vizmat.Distance(self.__view.get(viz.HEAD_POS),self.__center) / 8.0
		self.__view.move(0,0,dir*distance)

	def rotateRight(self,amount):
		distance = vizmat.Distance(self.__view.get(viz.HEAD_POS),self.__center)
		self.__view.move(-distance*amount,0,0)
		self.__view.lookat(self.__center)
		headPos = viz.Vector(self.__view.get(viz.HEAD_POS))
		headPos = headPos - self.__center
		headPos.normalize()
		headPos *= distance
		headPos = headPos + self.__center
		self.__view.translate(headPos.get())
	def rotateUp(self,amount):
		oldPos = self.__view.get(viz.HEAD_POS)
		oldRot = self.__view.get(viz.HEAD_QUAT)
		distance = vizmat.Distance(self.__view.get(viz.HEAD_POS),self.__center)
		self.__view.move(0,-distance*amount,0)
		self.__view.lookat(self.__center)
		if abs(self.__view.get(viz.HEAD_PITCH)) > 85.0:
			self.__view.translate(oldPos)
			self.__view.rotatequat(oldRot)
			return
		headPos = viz.Vector(self.__view.get(viz.HEAD_POS))
		headPos = headPos - self.__center
		headPos.normalize()
		headPos *= distance
		headPos = headPos + self.__center
		self.__view.translate(headPos.get())
	def panRight(self,amount):
		mat = viz.Transform(self.__view.get(viz.HEAD_MAT))
		mat.setTrans(self.__center)
		mat.preTrans(amount,0,0)
		self.__center = mat.getTrans()
		self.__view.move(amount,0,0)
	def panUp(self,amount):
		mat = viz.Transform(self.__view.get(viz.HEAD_MAT))
		mat.setTrans(self.__center)
		mat.preTrans(0,amount,0)
		self.__center = mat.getTrans()
		self.__view.move(0,amount,0)
	def setCenter(self,center):
		diff = viz.Vector(center)
		diff = diff - self.__center
		pos = self.__view.get(viz.HEAD_POS)
		self.__view. translate(pos[0]+diff[0],pos[1]+diff[1],pos[2]+diff[2])
		self.__center = center

