﻿import viz
import vizmat
import viztask
import vizact

TRACTOR_TIME = 4

tractorNodes = []
def init(trackerNodeList):
	global startProjectSignal, tractorNodes
	tractorNodes = trackerNodeList
	startProjectSignal = viztask.Signal()
	viztask.schedule(think())

def startProject():
	global isProjectionDone
	startProjectSignal.send()
	
def stopProject():
	global isProjectionDone
	isProjectionDone = True

def think():
	global isProjectionDone
	cursor = viz.add('white_ball.wrl')
	cursor.color(viz.GREEN)
	cursor.alpha(.5)
	cursor.visible(viz.OFF)
	viz.startLayer(viz.LINES)
	viz.vertex([0,0,0])
	viz.vertex([0,0,0])
	lazer = viz.endLayer()
	lazer.color(viz.GREEN)
	lazer.visible(viz.OFF)
	while True:
#		print 'wait'
		yield startProjectSignal.wait()
		print 'start tractor'
		isProjectionDone = False
		cursor.visible(viz.ON)
		lazer.visible(viz.ON)
		hitObject = None
		while not isProjectionDone:
			line = viz.MainWindow.screenToWorld([.5, .5])
			line.length = 100
			lazerStart = line.begin
			lazerStart[1] -= .1 
			lazer.setVertex(0, lazerStart)
			lazer.setVertex(1, line.end)
			intersectObj = viz.phys.intersectLine(line.begin, line.end)
			if intersectObj.valid:
				cursor.setPosition(intersectObj.point)
				if intersectObj.object in tractorNodes:
					hitObject = intersectObj.object
				else:
					hitObject = None
			yield None
#		print 'done'
		cursor.visible(viz.OFF)
		lazer.visible(viz.OFF)
		if hitObject:
			#start Tractor
			isProjectionDone = False
			startTime = viz.tick()
			startPos = hitObject.getPosition(viz.ABS_GLOBAL)
			while not isProjectionDone:
				percentageToGo = min( (viz.tick()-startTime) / TRACTOR_TIME, 1)
				line = viz.MainWindow.screenToWorld([.5, .5])
				line.length = .5
				targetPos = line.end
				pos = vizmat.Interpolate(hitObject.getPosition(viz.ABS_GLOBAL), targetPos, percentageToGo)
				hitObject.setPosition(pos, viz.ABS_GLOBAL)
				yield None
			hitObject.runAction( vizact.moveTo(startPos, time=TRACTOR_TIME*.2) )
		
		
if __name__ == "__main__":
	viz.go()
	viz.phys.enable()
	room = viz.add('gallery.osgb')
	room.collideMesh()
	list = []
	for i in range(5):
		b = viz.add('box.wrl', pos=[i*1.2, 1, 2], scale=[.2]*3)
		b.collideMesh()
		list.append(b)
		
	init(list)	
	import vizact
	vizact.onkeydown(' ', startProject)
	vizact.onkeyup(' ', stopProject)
	