--	Enables Tiling on objects and reduces the tiling amount from 1 to 0.98 if tiling was disabled. 
--	Also works for maps where Real World Scale is in use.
--	Also works for multi-materials

fn fixTiling inMap = 
-- Checks whether RWS is enabled, entables tiling, and tweaks the tiling amount.
(
	imc = inMap.coords
	
	if imc.realWorldScale == false then
	(
		if imc.U_Tile == false then (imc.U_Tile = true; imc.U_Tiling *= 0.98)
		if imc.V_Tile == false then (imc.V_Tile = true; imc.V_Tiling *= 0.98)
	)
			
	if imc.realWorldScale == true then
	(
		if imc.U_Tile == false then (imc.U_Tile = true; imc.U_Tiling *= 1.02041)
		if imc.V_Tile == false then (imc.V_Tile = true; imc.V_Tiling *= 1.02041)
	)
	return inMap
)

for m in scenematerials do
(
-- In all scene materials
	if classof m == Standardmaterial then 
	(
		-- Check if the mateiral type is a Standard
		if classof m.diffuseMap == Bitmaptexture then (m.diffuseMap = fixTiling(m.diffuseMap))
 		if classof m.opacityMap == Bitmaptexture then (m.opacityMap = fixTiling(m.opacityMap))
	)
	
	if classof m == multimaterial then 
	(
		for s in m do
		(
			if classof s == Standardmaterial then 
			(
				-- Check if the mateiral type is a Standard
				if classof s.diffuseMap == Bitmaptexture then (s.diffuseMap = fixTiling(s.diffuseMap))
				if classof s.opacityMap == Bitmaptexture then (s.opacityMap = fixTiling(s.opacityMap))
			)
		)
	)
)