import viz

viz.go()

#Create an object to apply bump map to
planet = viz.add('planet.wrl')
planet.translate(0,1.8,1)
planet.scale(20,20,20)
planet.spin(0,1,0,30)
planet.spinning = 1

#The diffuse texture
diff = viz.add('mercury.jpg')

#The normal map texture
norm = viz.add('mercurybump.jpg')

#Apply diffuse texture to unit 1
planet.texture(diff,'',1)

#Apply normal map texture to unit 0
planet.bumpmap(norm,'',0)

#Press spacebar to toggle spinning of object
def onkeydown(key):
	if key == ' ':
		planet.spinning = not planet.spinning
		planet.spin(0,1,0,30*planet.spinning)

viz.callback(viz.KEYDOWN_EVENT,onkeydown)

#Set background color
viz.clearcolor(viz.SKYBLUE)
