import viz
import spaceball

TRANSLATE_EVENT		= 0
ROTATE_EVENT		= 1
BUTTONDOWN_EVENT	= 2
BUTTONUP_EVENT		= 3

class __SpaceballHandler(viz.EventClass):
	
	def __init__(self):
		
		viz.EventClass.__init__(self)
		
		self.callback(viz.TIMER_EVENT,self.mytimer)
		self.starttimer(0,0,viz.FOREVER)
		
		self.pos_func = 0
		self.rot_func = 0
		self.down_func = 0
		self.up_func = 0
		
	def mytimer(self,num):
		events = spaceball.getmotionevents()
		for e in events:
			elapsed = (e[6] / 1000.0)
		
			pos = [e[0],e[1],e[2]]
			if self.pos_func:
				self.pos_func(pos,elapsed)
			
			ori = [-e[3],-e[4],-e[5]]
			if self.rot_func:
				self.rot_func(ori,elapsed)
			
		events = spaceball.getbuttonevents()
		for e in events:
			if e[1]:
				if self.down_func:
					self.down_func(e[0])
			else:
				if self.up_func:
					self.up_func(e[0])

__instance = __SpaceballHandler()

def callback(event,func):
	if event == TRANSLATE_EVENT:
		__instance.pos_func = func
	elif event == ROTATE_EVENT:
		__instance.rot_func = func
	elif event == BUTTONDOWN_EVENT:
		__instance.down_func = func
	elif event == BUTTONUP_EVENT:
		__instance.up_func = func
		