import viz
viz.go()

viz.add('tut_ground.wrl')

#NOTE, the delayload plugin takes two arguments
#The first argument can be either 0 or 1
# 0 means the function won't return until the file is loaded, but it won't block the main application
# 1 means the function will return immediately, but the model won't show up until it is loaded
#The second argument is the file to load

def loadmodel(filename):
	#Won't return until model is loaded
	viz.add('delayload.dlc',0,filename)

def onkeydown(key):
	if key == ' ':
		#Load the model in a thread
		viz.director(loadmodel,'mini.osgx')
	if key == 'd':
		#Will return immediately, but model won't show up until it is loaded
		car = viz.add('delayload.dlc',1,'mini.osgx')
		car.spin(0,1,0,30)

viz.callback(viz.KEYDOWN_EVENT,onkeydown)
