﻿import viz
import vizact
import vizshape

viz.go()

viz.phys.enable()
viz.phys.setAccuracy(4)
viz.phys.setStepSize(0.01)
viz.MainView.setPosition(0,2,-10)

ground = viz.addChild('ground.osgb')
ground.setPosition(0,0,0)
ground.collidePlane()
excav = viz.addChild('import/excav_Forum.ive')
excav.setScale(0.5,0.5,0.5)

#Setup of Excavator Arms
base = excav.getChild('base')
base.disable(viz.CONTACTS)
turningPlate = excav.getChild('turningPlate')
turningPlate.disable(viz.CONTACTS)
arm1 = excav.getChild('arm1')
arm1.disable(viz.CONTACTS)
arm2 = excav.getChild('arm2')
arm2.disable(viz.CONTACTS)
arm3 = excav.getChild('arm3')
arm3.setParent(arm2)
bucket = excav.getChild('bucket')
bucket.disable(viz.CONTACTS)

collisionBox1 = excav.getChild('collisionCube1')
collisionBox2 = excav.getChild('collisionCube2')
collisionBox3 = excav.getChild('collisionCube3')
collisionBox4 = excav.getChild('collisionCube4')
collisionBox7 = excav.getChild('collisionCube7')

#Object to pick up
#box = viz.addChild( 'box.wrl', pos=[-2,0.5,-3] )
#box.setScale( [.5]*3 )
#box.collideBox(density = 0.0000001, friction = .000001)

basePhysics = base.collideBox(density=1)
turningPlate.collideBox(density=0.0000001);
arm1.collideBox(density=0.0000001);
arm2.collideBox(density=0.0000001);
bucket.collideBox(density=0.0000001);
bucket.disable(viz.RENDERING) #makes an object invisible
bucket.disable(viz.DEPTH_WRITE)

collisionBox1.collideBox(density=0.0000001, bounce = 0, friction=0.000001, hardness=0.0000001);
collisionBox2.collideBox(density=0.0000001, bounce = 0, friction=0.000001, hardness=0.0000001);
collisionBox3.collideBox(density=0.0000001, bounce = 0, friction=0.000001, hardness=0.0000001);
collisionBox4.collideBox(density=0.0000001, bounce = 0, friction=0.000001, hardness=0.0000001);
collisionBox7.collideBox(density=0.0000001, bounce = 0, friction=0.000001, hardness=0.0000001);

joint0 = viz.phys.addFixedJoint(base, None)
joint1 = viz.phys.addHingeJoint(turningPlate, base, axis0=[0, 1, 0], pos=excav.getChild('turningPlate-GEODE').getPosition(viz.ABS_GLOBAL))
joint2 = viz.phys.addHingeJoint(arm1, turningPlate, axis0=[1, 0, 0], pos=excav.getChild('arm1-GEODE').getPosition(viz.ABS_GLOBAL))
joint3 = viz.phys.addHingeJoint(arm2, arm1, axis0=[1, 0, 0], pos=excav.getChild('arm2-GEODE').getPosition(viz.ABS_GLOBAL))
joint4 = viz.phys.addHingeJoint(bucket, arm2, axis0=[1, 0, 0], pos=excav.getChild('bucket-GEODE').getPosition(viz.ABS_GLOBAL))

#joint0.setAxisFriction(0,10000)
#joint1.setAxisFriction(0,10000)
#joint2.setAxisFriction(0,10000)
#joint3.setAxisFriction(0,10000)
#joint4.setAxisFriction(0,10000)
#joint0.setAxisHardness(0,10000)
#joint1.setAxisHardness(0,10000)
#joint2.setAxisHardness(0,10000)
#joint3.setAxisHardness(0,10000)
#joint4.setAxisHardness(0,10000)

jointColl1 = viz.phys.addFixedJoint(collisionBox1, bucket, pos=excav.getChild('collisionCube1-GEODE').getPosition(viz.ABS_GLOBAL))
jointColl2 = viz.phys.addFixedJoint(collisionBox2, collisionBox1, pos=excav.getChild('collisionCube2-GEODE').getPosition(viz.ABS_GLOBAL))
jointColl3 = viz.phys.addFixedJoint(collisionBox3, collisionBox2, pos=excav.getChild('collisionCube3-GEODE').getPosition(viz.ABS_GLOBAL))
jointColl4 = viz.phys.addFixedJoint(collisionBox4, collisionBox3, pos=excav.getChild('collisionCube4-GEODE').getPosition(viz.ABS_GLOBAL))
jointColl7 = viz.phys.addFixedJoint(collisionBox7, collisionBox4, pos=excav.getChild('collisionCube7-GEODE').getPosition(viz.ABS_GLOBAL))

joint1.setMotorAngle(0, 0, speed=1, maxTorque=10)
joint2.setMotorAngle(0, 0, speed=1, maxTorque=10)
joint3.setMotorAngle(0, 0, speed=1, maxTorque=10)
joint4.setMotorAngle(0, 0, speed=1, maxTorque=10)


def rotateJoint(joint, offset, minAngle=-90, maxAngle=90, speed=0.5, axis=0, maxTorque=10):
	'''
	Rotates the joints.
	@param joint: Joint which shall be rotated
	@param offset: Determines how many degrees the joint is rotating per call of this method
	@param minAngle: Constrains the rotation to a certain minimum angle
	@param maxAngle: Constrains the rotation to a certain maximum angle
	@param speed: Lower speed (e.g. 0.1) makes soft movement and not so mechanic
	@param axis: default 0, in a hinge joint there is only one axis. If there would be more axes than, e.g. universal or ball joint, you could pick one of the given axes.
	'''
	joint.setAxisLimit(axis,minAngle,maxAngle) #axis=0, this is the num parameter if you go to the definition
	joint.setMotorAngle(axis, joint.getAxisAngle(axis) + offset, speed=speed, maxTorque=maxTorque) #maxTorque=10 for setting the effectiveness stronger to move the cube/ducks


vizact.whilekeydown('q', rotateJoint, joint1, 1)
vizact.whilekeydown('a', rotateJoint, joint1, -1)
vizact.whilekeydown('w', rotateJoint, joint2, 1)
vizact.whilekeydown('s', rotateJoint, joint2, -1)
vizact.whilekeydown('e', rotateJoint, joint3, 1)
vizact.whilekeydown('d', rotateJoint, joint3, -1)
vizact.whilekeydown('r', rotateJoint, joint4, 1)
vizact.whilekeydown('f', rotateJoint, joint4, -1)


