import viz
viz.go()

import viznet

#Create custom event IDs
CLIENT_KEYDOWN = viznet.id('ClientKeyDown')
SET_CLEAR_COLOR = viznet.id('SetClearColor')

#Start server
viznet.server.start()

colors = [viz.RED,viz.BLUE,viz.BLACK,viz.ORANGE,viz.YELLOW,viz.GREEN,viz.GRAY]
curColor = 0

#When client connects, send them current color
def onStartClient(e):
	viznet.server.sendClient(e.sender,SET_CLEAR_COLOR,color=colors[curColor])
	print '** Client joined:',e.sender
viz.callback(viznet.CLIENT_CONNECT_EVENT,onStartClient)

#Print out when client leaves
def onStopClient(e):
	print '** Client left:',e.sender
viz.callback(viznet.CLIENT_DISCONNECT_EVENT,onStopClient)

#When client presses space key, change color and notify all clients
def onKeydownClient(e):
	global curColor
	if e.keydown == ' ':
		curColor = (curColor + 1) % len(colors)
		viznet.server.send(SET_CLEAR_COLOR,color=colors[curColor])
viz.callback(CLIENT_KEYDOWN,onKeydownClient)