#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include "gldraw.h"

#include "sensor.h"

/////////////////////////////////////////////////////////////
//Some declarations only needed for this particular example//
//                                                         //

extern void Draw(void);
extern char InitDraw(void);
extern void AddVertex(int obj,float x, float y, float z);
extern void RotationCenter(int obj);
extern void Rotate(int obj);
extern DRAWOBJ dobj[MAX_INSTANCES];
extern int renderStyle;
extern int pointSize;
extern int lineWidth;
extern int numVertices;
extern float r,g,b;
extern int rotateflag[MAX_INSTANCES];

int numObj;

//This example will simulate the head moving in a circle   //
/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////

// DO NOT MODIFY THESE DECLARATIONS----------------
extern "C" __declspec(dllexport) void QuerySensor(void *);
extern "C" __declspec(dllexport) void InitializeSensor(void *);
extern "C" __declspec(dllexport) void UpdateSensor(void *);
extern "C" __declspec(dllexport) void CommandSensor(void *);
extern "C" __declspec(dllexport) void ResetSensor(void *);
extern "C" __declspec(dllexport) void CloseSensor(void *);

void QuerySensor(void *sensor)
{
	// This function gets called during the Vizard initialization process.
	// Its only purpose is to set the sensor type (see choices in sensor.h),
	// so that it can be automatically made available to the user according
	// to its type.
	// No initialization or communication should be attempted at this point
	// because the device may never be requested by user (and it might not
	// even be connected!).

	//A short description of your plugin
	strcpy(((VRUTSensorObj *)sensor)->version, "OpenGL Drawer");
	//Your plugin type e.g.( SENSOR_HEADPOS | SENSOR_HEADORI | SENSOR_QUATERNION )
	
	((VRUTSensorObj *)sensor)->type = SENSOR_ENGINE;
}


void InitializeSensor(void *sensor)
{
	//Called each time an instance is created.

	//This function will attempt to connect to the device and initialize any variables.

	//You can set the size of the data field to any value.
	//After this function is called, Vizard will allocate the
	//data field of the plugin to the size given here. Then you
	//can put any values you want in the data field and the user
	//can get those values by calling the "get" command on the
	//sensor object in the script.
	//It is suggested that the size of the data field be 7 or higher
	((VRUTSensorObj*)sensor)->dataSize = 7;

	//If you have multiple instances you can store your own unique
	//identifier in the user data fields.
	((VRUTSensorObj*)sensor)->user[0] = 0;

	//If initialization failed then set status to FALSE, if it succeeded set it to TRUE.
	((VRUTSensorObj *)sensor)->status = TRUE;

	((VRUTSensorObj *)sensor)->custom = (void *)malloc(300);
	*((char *)((VRUTSensorObj *)sensor)->custom) = '\0';

	InitDraw();
}


void UpdateSensor(void *sensor)
{
	if(numObj > 0)
		Draw(); 
}


void ResetSensor(void *sensor)
{
	// If the user were to send a reset command, do whatever makes sense to do.
}

void CommandSensor(void *sensor)
{
	float	newValue;
	char msg[128],msgg[128];
    char *pdest;
    int result;
	int medianum;
	char vOffset[128], *hOffset, *boxSize;
  	char *xx, *yy, *zz;
  	char *pos1, *pos2, *pos3, *pos4, *pos5;
	int ptr,o,dstate,i,j;		
	float x,y,z,r,g,b,width;

	r=g=b=width=0.0;
	switch( (int) ((VRUTSensorObj *)sensor)->command) {
	// Add vertex to current object
	case 1:			
		strcpy(msg,(char *)((VRUTSensorObj *)sensor)->custom); 
		// Parse the string
		strcpy(vOffset,msg);   
		pos1 = strpbrk(vOffset, "," );
		ptr = pos1 - vOffset;
		vOffset[ptr] = '\0';
		x = atof(vOffset);

		pos1++;
		pos2 = strpbrk( pos1, "," );
		ptr = pos2 - pos1;
		pos1[ptr] = '\0';
		hOffset = pos1;
		y = atof(hOffset);

		pos2++;
		z = atof(pos2);
		dobj[numObj-1].totVertices++;
		if(numObj > 0)
			AddVertex(numObj-1,x,y,z);
		//		RotationCenter(numObj-1);
		break;
	// Rotate
	case 2:
		if(numObj > 0){
			if(rotateflag[numObj-1] == 1){
				printf("dont spin\n");
				rotateflag[numObj-1] = 0;
			}
			else{
				printf("spin\n");
				rotateflag[numObj-1] = 1;
			}
			RotationCenter(numObj-1);
		}
		break;
	// Draw lines or points
	case 4:
		if(numObj > 0)
			dobj[numObj-1].renderStyle = 0;
		break;
	case 5:
		if(numObj > 0)
			dobj[numObj-1].renderStyle = 1;
		break;
	// Line width
	case 6:
		if(numObj > 0){
			strcpy(msg,(char *)((VRUTSensorObj *)sensor)->custom); 
			dobj[numObj-1].lineWidth = atoi(msg);
		}
		break;
	// Point size
	case 7:
		if(numObj > 0){
			strcpy(msg,(char *)((VRUTSensorObj *)sensor)->custom); 
			dobj[numObj-1].pointSize = atoi(msg);
		}
		break;
	// Erase last object
	case 8:
		if(numObj > 0){
			dobj[numObj-1].numVertices = 0;
			dobj[numObj-1].totVertices=0;
			dobj[numObj-1].renderStyle=1;
			dobj[numObj-1].pointSize=4;
			dobj[numObj-1].lineWidth=2;
			dobj[numObj-1].r = 1.0;
			dobj[numObj-1].g = 1.0;
			dobj[numObj-1].b = 1.0;
			numObj--;
		}
		break;
	// Color
	case 9:
		strcpy(msg,(char *)((VRUTSensorObj *)sensor)->custom); 
		if(numObj > 0){
			// Parse the string
			strcpy(vOffset,msg);   
			pos1 = strpbrk(vOffset, "," );
			ptr = pos1 - vOffset;
			vOffset[ptr] = '\0';
			dobj[numObj-1].r = atof(vOffset);

			pos1++;
			pos2 = strpbrk( pos1, "," );
			ptr = pos2 - pos1;
			pos1[ptr] = '\0';
			hOffset = pos1;
			dobj[numObj-1].g = atof(hOffset);

			pos2++;
			dobj[numObj-1].b = atof(pos2);
		}
		break;
	// Start new object
	case 10:
		if(numObj < MAX_INSTANCES)
			numObj++;
		//printf("Drawing object %d started\n",numObj);
		break;
	// Reverse erase elements of an object
	case 11:		
		if(numObj > 0)
			if(dobj[numObj-1].numVertices > 0)
				if(dobj[numObj-1].numVertices-- == 0)
					numObj--;
		break;
	// curtain or uncurtain objects
	case 12:
		strcpy(msg,(char *)((VRUTSensorObj *)sensor)->custom); 

		// Parse the string
		strcpy(vOffset,msg);   
		pos4 = strpbrk(vOffset, "," );
		ptr = pos4 - vOffset;
		vOffset[ptr] = '\0';
		o = atoi(vOffset);
		pos4++;
		dstate = atoi(pos4);
		if(numObj > 0){
			if(dstate == 0)
				dobj[o-1].numVertices = 0;
			else
				dobj[o-1].numVertices = dobj[o-1].totVertices;
		}
		break;
	// Erase all
	case 15:
		numObj = 0;
		break;
	}
}

void CloseSensor(void *sensor)
{
	numObj = 0;
}