#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "glut.h"

#include <gl\gl.h>              // OpenGL
#include <gl\glu.h>
#include "gldraw.h"

static float		vertices[MAX_VERTICES][3];
int rotateflag[MAX_INSTANCES];
float r,g,b,meanx,meany,meanz;
int		numVertices, numPolys = 0, numTs = 0, numRs = 0;
int		renderStyle,lineWidth,pointSize;

DRAWOBJ dobj[MAX_INSTANCES];

extern int		numObj;


void
RotationCenter(int obj)
{
	int i;
	float x=0,y=0,z=0;

	// Calculate mean x,y,z
	for (i=0; i<dobj[numObj-1].numVertices; i++) {
		x += dobj[numObj-1].vertices[i].x;
		y += dobj[numObj-1].vertices[i].y;
		z += dobj[numObj-1].vertices[i].z;
	}
	x /= dobj[numObj-1].numVertices;
	y /= dobj[numObj-1].numVertices;
	z /= dobj[numObj-1].numVertices;

	for (i=0; i<dobj[numObj-1].numVertices; i++) {
		dobj[numObj-1].vertices[i].x -= x;
		dobj[numObj-1].vertices[i].y -= y;
		dobj[numObj-1].vertices[i].z -= z;
	}
}


void
Draw(void)
{
	int i, j, k, d, v;
	float	x, y, z, w;
	static float ang=0;

	ang += 1;

	for (k=0; k<numObj; k++) {
		i = 0;

		glPushMatrix();
		if(rotateflag[k] == 1)
			glRotatef(ang, 0, -1, 0);
		
		glLineWidth(dobj[k].lineWidth);
		glPointSize(dobj[k].pointSize);
		glColor3f(dobj[k].r,dobj[k].g,dobj[k].b);

		if (dobj[k].renderStyle == 0) glBegin(GL_POINTS);
		if (dobj[k].renderStyle == 1) glBegin(GL_LINE_STRIP);
		for (i=0; i<dobj[k].numVertices; i++) {
			x = dobj[k].vertices[i].x;
			y = dobj[k].vertices[i].y;
			z = dobj[k].vertices[i].z;
			glVertex3f(x, y, z);
		}
		glEnd();
		glPopMatrix();
	}
	
    glEnable(GL_POINT_SMOOTH);
    glEnable(GL_LINE_SMOOTH);
    glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
    glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
    //glEnable(GL_BLEND);
    //glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

}

void
AddVertex(int obj,float x, float y, float z)
{
	int i;
	
	dobj[obj].vertices[dobj[obj].numVertices].x = x;	
	dobj[obj].vertices[dobj[obj].numVertices].y = y;	
	dobj[obj].vertices[dobj[obj].numVertices].z = -z;	
	dobj[obj].numVertices++;
	
}

char
InitDraw(void)
{
	int i;
	
	for (i=0; i<MAX_INSTANCES; i++) {
		dobj[i].totVertices=0;
		dobj[i].numVertices=0;
		dobj[i].renderStyle=1;
		dobj[i].pointSize=4;
		dobj[i].lineWidth=2;
		dobj[i].r = 1.0;
		dobj[i].g = 0.0;
		dobj[i].b = 1.0;
	}
	return 1;
}
