import viz, os, vizshape

from input import DummyUser, EventManager
from actions import PlaneForward, PlaneBank
viz.go()
viz.setOption('viz.antialias',16)
plane = viz.addGroup()
planeFrame = vizshape.addBox([10,0.1,3],parent=plane)
chairs = vizshape.addBox([1.5,1.5,1.5],parent=plane)

planeFrame.appearance(viz.DECAL)
chairs.appearance(viz.DECAL)

planeFrame.setPosition(0,-1.5,0)
chairs.setPosition(-0.8,-0.75,0)


#Add user
user = DummyUser()
user.setEuler(-25,0,0)

#Add eventManager
eventManager = EventManager(user)

#Initialize view update   
def setView(event):
        
        matLoc = plane.getMatrix(viz.ABS_GLOBAL)
        matUser = user.getMatrix()

        matFinal = vizmat.Transform()
        matFinal.preMult(matLoc)
        matFinal.preMult(matUser)

        viz.MainView.setMatrix(matFinal)

viz.callback(viz.UPDATE_EVENT, setView)
plane.airSpeed = 355.0
plane.maxBankAngle = 35
plane.bankingSpeed = 2.5
plane.addAction(PlaneForward.getAction(), 1)

planeBankAction = PlaneBank.getAction()

plane.addAction(planeBankAction,2)
slider = viz.addSlider()
slider.setPosition(0.1, 0.1, 0.1)
def bankSlider(pos):
	planeBankAction.setNewBankTarget((pos - 0.5) * 60)

vizact.onslider(slider, bankSlider)
