import viz
viz.go()

viz.add('tut_ground.wrl')

ball1 = viz.add('ball.wrl')
ball1.translate(-2,1,5)
ball1.tooltip = 'Ball 1\nPos = 1.0'

ball2 = viz.add('ball.wrl')
ball2.translate(0,1,5)
ball2.tooltip = 'Ball 2'

ball3 = viz.add('ball.wrl')
ball3.translate(2,1,5)
ball3.spin(0,1,0,90)
ball3.tooltip = 'Ball 3'

import vizinfo

TOOLTIP_EVENT = 90

class ToolTipHandler(viz.EventClass):

	def __init__(self):
		viz.EventClass.__init__(self)

		self._delay = 0.5
		self._track = 1

		self._curTime = 0.0
		self._curObject = 0
		self._displayObject = 0

		self._infobox = vizinfo.add('',0.75)
		self._infobox.bordercolor(viz.BLACK)
		self._infobox.bgcolor(1,1,0.88,0.8)
		self._infobox._text.color(viz.BLACK)
		self._infobox._checkbox.visible(0)
		self._infobox._group.visible(0)
		self._infobox.alignment(vizinfo.UPPER_LEFT)

		self._displayCB = 0

		viz.EventClass.callback(self,viz.TIMER_EVENT,self._mytimer)

	def callback(self,event,func):
		if event == TOOLTIP_EVENT:
			self._displayCB = func

	def start(self):
		self.killtimer(0)
		self.starttimer(0,0.01,viz.FOREVER)

	def stop(self):
		self.killtimer(0)

	def delay(self,value):
		self._delay = value

	def message(self,value):
		self._infobox.message(value)

	def visible(self,state):
		self._infobox._group.visible(state)

	def translate(self,x,y=0):
		if viz._islist(x):
			xval = x[0]
			yval = x[1]
		else:
			xval = x
			yval = y
		bb = self._infobox._group.get(viz.BOUNDING_BOX)
		self._infobox.translate(viz.clamp(xval,0.0,1.0-bb[0]),viz.clamp(yval,0.0+bb[1],1.0))

	def _resettrackstate(self,object):
		self.visible(0)
		self._displayObject = 0
		self._curObject = object
		self._curTime = 0.0

	def _mytimer(self,num):
		object = viz.pick()
		if object.valid():
			#Mouse is over an object
			if object == self._curObject:
				#Mouse is over same object as before
				if not self._displayObject:
					#The object is waiting for delay to expire
					self._curTime += viz.elapsed()
					if self._curTime > self._delay:
						#Delay time has expired, display tooltip of object
						try:
							#Perform display callback
							if self._displayCB:
								self._displayCB(object)
							#Check if object has tooltip text
							text = object.tooltip
							self.message(text)
							self._displayObject = object
							self.translate(viz.mousepos())
							self.visible(1)
						except:
							#Object does not contain tooltip, clear track state
							self._resettrackstate(0)
				else:
					#Object tooltip is already being displayed, update position
					if self._track:
						self.translate(viz.mousepos())
			else:
				#Mouse if over a new object, reset track state
				self._resettrackstate(object)
		else:
				#Mouse is not over an object, clear track state
				self._resettrackstate(0)

def ontooltip(object):
	if object == ball3:
		ball3.tooltip = 'Yaw: %.2f'%ball3.get(viz.EULER)[0]

tth = ToolTipHandler()
tth.callback(TOOLTIP_EVENT,ontooltip)
tth.start()