import viz
import math

import vizinfo
import vizact

viz.go()                                       
[x,y,z]= viz.MainView.getPosition()
[yaw,pitch,roll]= viz.MainView.getEuler()
viz.MainView.setPosition(100,100,-750)
viz.MainView.setEuler(0,0,0)
viz.clearcolor(viz.SKYBLUE)

# background
hotel= viz.add('BigHotel45.3ds')
help_label= viz.addText('Welcome', viz.SCREEN)
help_label.fontSize(100)
help_label.color(viz.YELLOW)
help_label.setPosition(50,1,-100)

g=viz.add('vcc_male.cfg')
g.translate(-155,150,150)
g.rotate(180)
g.scale(30,30,0)
g.state(3)

h=viz.add('vcc_female.cfg')
h.translate(-175,159.9,150)
h.scale(20,24,0)
h.rotate(190)
h.state(4)

q=viz.add('vcc_female.cfg')
q.translate(-110,159.9,180)
q.scale(30,24,0)
q.rotate(180)
q.state(5) 

w=viz.add('vcc_male.cfg')
w.translate(-114,159.9,190)
w.scale(30,25,0)
w.rotate(180)
w.state(5) 

#path
myPathPos = [ [-1, 0, 0], [-1, 0, 2], [1, 0, 2], [1, 0, 0], [-1, 0, 0] ]
myPathOri = [ [0,0,0], [90, 0, 0], [180, 0, 0], [0, 0, 0], [0, 0, 0] ]
myPathTimeline = [ 0, 2, 4, 6, 8 ]
myPath = viz.add(viz.ANIMATION_PATH)  
for x in range(0, len(myPathPos)):
 tmpPoint = viz.addControlPoint()
 tmpPoint.setPosition(myPathPos[x])
 tmpPoint.setEuler(myPathOri[x])
 myPath.add(tmpPoint, myPathTimeline[x])
myPath.loop(viz.LOOP)

l=viz.add('vcc_female.cfg')
l.translate(5,1,-90)
l.scale(30,30,30)
l.state(2)
viz.link(myPath, l)
myPath.play()

mini = viz.add('mini.osgx')
mini.translate(50,1,-150)
mini.scale(30,30,30)

vizact.onkeydown('1',y.state,1)
vizact.onkeydown('2',y.state,2)

info=vizinfo.add('Determine the distance between point A and C, C and D, and A and D.')
info.title('Math Questions')

Btn=info.add(viz.RADIO,0, 'Start')
Btn2=info.add(viz.RADIO,1,'Reset')

viz.startlayer(viz.LINES)
viz.linewidth(3)
viz.vertexcolor(0,0,1)
viz.vertex(-164.51,155,98.180) 
viz.vertex(-184.23,1.0,-104.25)  
viz.vertex(-150.51,3,98.18)   
viz.vertex(-184.23,1.0,-104.25)
viz.vertex(-164.51,155,98.18) 
viz.vertex(-150.23,1.0,101)
coordinate= viz.endlayer()

viz.startlayer(viz.LINES)
viz.linewidth(4)
viz.vertexcolor(1,0,0)
          
viz.vertex(-184.23,1.0,-104.25)  
viz.vertex(0,4,98.18)
viz.vertex(0,3,98.18)  
viz.vertex(-150.23,1.0,101) 
coordinate= viz.endlayer()
text_3D = viz.addText( 'in the world', viz.WORLD)
text_3D.translate(-150.23,1.0,101)
def onkeydown(key):
 if key =='a':
   
   viz.MainView.setPosition(-500,100,-225) 
   viz.MainView.setEuler(70,0,0)
      
 elif key =='g':
   viz.MainView.setPosition(-550,200,-120) 
   viz.MainView.setEuler(80,20,-9)
 
 
 elif key =='p':
   viz.MainView.setPosition(-150,190,10) 
   viz.MainView.setEuler(0,0,0)
   
  elif key =='t':
   view2=viz.MainView.setPosition(0,1750,-500)
   viz.MainView.setEuler(0,75,0)
   
  elif key =='r':
   view3=viz.MainView.setPosition(500,100,100)
   viz.MainView.setEuler(0,0,0)
viz.callback(viz.KEYDOWN_EVENT, onkeydown)
 