import viz
viz.go(viz.FULLSCREEN)

#define height of texture quad in pixels to display video
HEIGHT = 300

#get webcam video
video = viz.add('VideoCamera.dle')
cam = video.addWebcam()

#get aspect ratio of video and calculate width of quad
size = cam.getSize()
ratio = float(size[0])/float(size[1])
WIDTH = ratio*HEIGHT

#add texture quad to the viz.ORTHO layer and link to upper left
quad = viz.addTexQuad(parent=viz.ORTHO,texture=cam,scale=[WIDTH,HEIGHT,1],align=viz.ALIGN_LEFT_TOP)
viz.link(viz.LeftTop,quad)

gallery = viz.add('gallery.ive')